% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{predict.risk_mod}
\alias{predict.risk_mod}
\title{Predict Method for Risk Model Fits}
\usage{
\method{predict}{risk_mod}(object, newx = NULL, type = c("link", "response", "score"), ...)
}
\arguments{
\item{object}{An object of class "risk_mod", usually a result of a call to
\code{\link[=risk_mod]{risk_mod()}}.}

\item{newx}{Optional matrix of new values for \code{X} for which predictions are
to be made. If ommited, the fitted values are used.}

\item{type}{The type of prediction required. The default ("link") is on the
scale of the predictors (i.e. log-odds); the "response" type is on the scale
of the response variable (i.e. risk probabilities); the "score" type returns
the risk score calculated from the integer model.}

\item{...}{Additional arguments.}
}
\value{
Numeric vector of predicted values.
}
\description{
Obtains predictions from risk score models.
}
\examples{
y <- breastcancer[[1]]
X <- as.matrix(breastcancer[,2:ncol(breastcancer)])
mod <- risk_mod(X, y, lambda0 = 0.01)
predict(mod, type = "link")[1]
predict(mod, type = "response")[1]
predict(mod, type = "score")[1]
}
