% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_exports.R
\name{get_exports}
\alias{get_exports}
\title{list all package exports}
\usage{
get_exports(pkg_source_path)
}
\arguments{
\item{pkg_source_path}{a file path pointing to an unpacked/untarred package directory}
}
\value{
data.frame, with one column `exported_function`, that can be passed
  to all downstream map_* helpers
}
\description{
list all package exports
}
\examples{
\donttest{
dp <- system.file("test-data", "test.package.0001_0.1.0.tar.gz",
package = "risk.assessr")

install_list <- set_up_pkg(dp)

build_vignettes <- install_list$build_vignettes
package_installed <- install_list$package_installed
pkg_source_path <- install_list$pkg_source_path
rcmdcheck_args <- install_list$rcmdcheck_args

get_exports_df <- get_exports(pkg_source_path)
}
}
