% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptest.R
\name{proptest}
\alias{proptest}
\alias{proptest.do}
\alias{plot.proptest}
\alias{print.proptest}
\alias{proptest.default}
\title{Test of proportions with improved layout}
\usage{
proptest(
  var1,
  var2 = NULL,
  by = NULL,
  exact = FALSE,
  null.hypoth = ifelse(is.null(var2) && is.null(by), 0.5, 0),
  alternative = "two.sided",
  conf.level = 0.95,
  correct = FALSE,
  more.digits = 0
)
}
\arguments{
\item{var1}{a (non-empty) vector of binary numeric (0-1), binary factor, or logical
data values}

\item{var2}{an optional (non-empty)
vector of binary numeric (0-1), binary factor, or logical
data values}

\item{by}{a variable of equal length to
that of \code{var1} with two outcomes (numeric or factor). This will be used to define strata
for a prop test on \code{var1}.}

\item{exact}{If true, performs a
test of equality of proportions using exact binomial probabilities.}

\item{null.hypoth}{a number specifying the
null hypothesis for the mean (or difference in means if performing a
two-sample test). Defaults to 0.5 for a one-sample test and 0 for a two-sample test.}

\item{alternative}{a string: one of
\code{"less"}, \code{"two.sided"}, or \code{"greater"} specifying the form
of the test. Defaults to a two-sided test.}

\item{conf.level}{confidence level of the
test. Defaults to 0.95.}

\item{correct}{a logical indicating whether to perform a continuity correction}

\item{more.digits}{a numeric value
specifying whether or not to display more or fewer digits in the output.
Non-integers are automatically rounded down.}
}
\value{
A list of class \code{proptest}. The print method lays out the information in an easy-to-read
format. 
\item{tab}{A formatted table of descriptive and inferential results (total number of observations,
number of missing observations, sample proportion, standard error of the proportion estimate), 
along with a confidence interval for the underlying proportion.}
\item{zstat}{the value of the test
statistic, if using an approximate test.} 
\item{pval}{the p-value
for the test} 
\item{var1}{The user-supplied first data vector. }
\item{var2}{The user-supplied second data vector. }
\item{by}{The user-supplied stratification variable.}
\item{par}{A vector of information about the type of test (null hypothesis, alternative hypothesis, etc.)}
}
\description{
Performs a one- or two-sample test of proportions using data. This test can be approximate or exact.
}
\details{
Missing values must be given by \code{"NA"}s to be recognized as missing values. 
Numeric data must be given in 0-1 form. 
This function also accepts binary factor variables, treating the higher level as 1 and the lower level 
as 0, or logical variables.
}
\examples{

# Read in data set
data(psa)
attach(psa)

# Define new binary variable as indicator
# of whether or not bss was worst possible
bssworst <- bss
bssworst[bss == 1] <- 0
bssworst[bss == 2] <- 0
bssworst[bss == 3] <- 1


# Perform test comparing proportion in remission
# between bss strata
proptest(factor(inrem), by = bssworst)

}
\seealso{
\code{\link[stats]{prop.test}}
}
