% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{compute_generalized_lorenz_ordinates}
\alias{compute_generalized_lorenz_ordinates}
\title{Generalized Lorenz ordinates}
\usage{
compute_generalized_lorenz_ordinates(dep_var, weights)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.}
}
\value{
thes generalized Lorenz ordinates for a vector \code{dep_var}.
}
\description{
Compute the generalized Lorenz ordinates of \code{dep_var} (i.e. the
share of total income observations up to each value in \code{dep_var} amass
scaled by the mean income).
}
\examples{

dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
weights <- c(2, 1, 3, 4, 4, 1, 6, 3)
generalized_lorenz_ordinates <-
  compute_generalized_lorenz_ordinates(
    dep_var = dep_var,
    weights = weights
  )

}
