% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{torus_pairs}
\alias{torus_pairs}
\title{Toroidal pairs plot}
\usage{
torus_pairs(
  x,
  max_dim = 10,
  columns = NULL,
  col_data = 1,
  ylim_dens = c(0, 1.5),
  bwd = "ROT",
  scales = rep(pi, ncol(x))
)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, d)} with angles on \eqn{[-\pi, \pi)}.}

\item{max_dim}{the maximum number of scores to produce the scores plot.
Defaults to \code{10}.}

\item{columns}{if specified, the variables to be plotted. If \code{NULL}
(the default), the first \code{max_dim} variables are plotted.}

\item{col_data}{color(s) for the data points. Defaults to \code{1}.}

\item{ylim_dens}{common \code{ylim} for the diagonal plots. Defaults to
\code{c(0, 1)}.}

\item{bwd}{type of bandwidth selector used in the kernel density plots.
Either \code{"ROT"}, \code{"EMI"}, \code{"AMI"}, \code{"LSCV"}, or
\code{"LCV"}. See \code{\link[DirStats:bw_dir_pi]{bw_dir_pi}} and
\code{\link[DirStats:bw_dir_pi]{bw_dir_cv}}. Defaults to \code{"ROT"}.}

\item{scales}{scales of the torus. Defaults to \code{rep(pi, ncol(x))}.}
}
\value{
A \code{\link[ggplot2:ggplot2]{ggplot}}. The density plots show the
\link[=frechet_mean]{Fréchet means} (red bars) and the Fréchet standard
deviations (gray text).
}
\description{
Pairs plots for data on \eqn{[-\pi, \pi)^d}, \eqn{d\geq 2}.
The diagonal panels contain kernel density estimates tailored to
circular data.
}
\details{
The default bandwidth selector is the Rule-Of-Thumb (ROT) selector in
García-Portugués (2013). It is fast, yet it may oversmooth non-unimodal
densities. The EMI selector gives more flexible fits.
}
\examples{
# Generate data
n <- 50
set.seed(123456)
x <- sdetorus::toPiInt(rbind(
  mvtnorm::rmvnorm(n = n, mean = c(-pi, -pi) / 2,
                   sigma = diag(0.1, nrow = 2)),
  mvtnorm::rmvnorm(n = n, mean = c(-3 * pi / 2, 0) / 2,
          sigma = diag(0.1, nrow = 2)),
  mvtnorm::rmvnorm(n = n, mean = c(0, pi / 2),
                   sigma = diag(0.1, nrow = 2))
))
col <- rainbow(3)[rep(1:3, each = n)]

# Torus pairs
torus_pairs(x, col_data = col)
\donttest{
fit <- ridge_pca(x = x)
torus_pairs(fit$scores, col_data = col)}
}
\references{
García-Portugués, E. (2013). Exact risk improvement of bandwidth selectors
for kernel density estimation with directional data. \emph{Electronic Journal
of Statistics}, 7:1655--1685. \doi{10.1214/13-ejs821}
}
