% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frechet.R
\name{torus_dist}
\alias{torus_dist}
\title{Toroidal distances}
\usage{
torus_dist(x, y, squared = FALSE)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, d)} with angles on \eqn{[-\pi, \pi)}.}

\item{y}{either a matrix with the same size as \code{x} or a vector of
size \code{nx}.}

\item{squared}{return the squared distance? Defaults to \code{FALSE}.}
}
\value{
A vector of size \code{nx} with the distances between the
observations of \code{x} and \code{y}.
}
\description{
Computation of distances on \eqn{[-\pi, \pi)^d}, \eqn{d\geq 1},
between two sets of observations.
}
\details{
The maximal distance on \eqn{[-\pi, \pi)^d} is \eqn{\sqrt{d}\pi}.
}
\examples{
# Illustration of torus distances
n <- 10
x <- matrix(runif(2 * n, -pi, pi), nrow = n, ncol = 2)
y <- c(pi / 2, pi / 3)
col <- rainbow(n)
plot(x, xlim = c(-pi, pi), ylim = c(-pi, pi), axes = FALSE, col = col,
     xlab = expression(theta[1]), ylab = expression(theta[2]), pch = 16)
sdetorus::torusAxis()
points(y[1], y[2], col = 1, pch = 17)
for (i in 1:n) {

  sdetorus::linesTorus(x = c(x[i, 1], y[1]),
                       y = c(x[i, 2], y[2]), lty = 2, col = col[i])

}
text(x = x, labels = sprintf("\%.2f", torus_dist(x, y)), col = col, pos = 1)
}
