% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marine.R
\name{map.shells}
\alias{map.shells}
\title{Plot regional shell-derived dR values}
\usage{
map.shells(
  S = 48,
  W = -15,
  N = 62,
  E = 5,
  browse = FALSE,
  colour = "dR",
  rainbow = FALSE,
  size = 2,
  mapsize = "large",
  mincol = "yellow",
  maxcol = "red",
  symbol = "feeding",
  symbol.legend = TRUE,
  ocean.col = "aliceblue",
  land.col = rgb(0, 0.5, 0, 0.6),
  legend.loc = c(0.95, 0.02),
  legend.size = c(0.05, 0.2),
  padding = 0.1,
  warn = TRUE,
  currents = TRUE
)
}
\arguments{
\item{S}{The southern limit of the rectangular region.}

\item{W}{The western limit of the rectangular region.}

\item{N}{The northern limit of the rectangular region.}

\item{E}{The eastern limit of the rectangular region.}

\item{browse}{Type of map to provide. \code{browse=FALSE} (default) plots a static map in R's device (doesn't require Internet access), while \code{browse=TRUE} opens a browsable, interactive map in your Internet browser.}

\item{colour}{The variable to be plotted as colour. Expects a continuous variable. Defaults to 'dR'.}

\item{rainbow}{Whether or not to use a rainbow scale to plot the variable.}

\item{size}{Size of the symbols. Defaults to 2.}

\item{mapsize}{Resolution of the map. Can be "small" or "large". If the latter, a high-resolution dataset will have to be downloaded using the R package 'rnaturalearthhires'. Since this package is on github but not on CRAN, you will have to download it yourself (using the command devtools::install_github("ropensci/rnaturalearthhires")). Defaults to "small" if 'rnaturalearthhires' is not installed, and to "large" if it is installed.}

\item{mincol}{Colour for minimum values.}

\item{maxcol}{Colour for maximum values.}

\item{symbol}{The variable to be plotted as symbol. Expects a categoric variable. Defaults to 'feeding'.}

\item{symbol.legend}{Whether or not to plot the legend for the symbols.}

\item{ocean.col}{Colour for the oceans. Defaults to \code{ocean.col="aliceblue"}.}

\item{land.col}{Colour for the land. Defaults to semi-transparent darkgreen: \code{land.col=rgb(0, 0.5, 0, 0.6)}.}

\item{legend.loc}{Location of the legend, if using a basic plot. Defaults to the bottom right corner based on par("usr"), \code{legend.loc=c(0.95, 0.02)}}

\item{legend.size}{Size of the legend, if using a basic plot. Defaults to \code{legend.size=c(0.05, 0.2)}}

\item{padding}{Area around the map if using a basic plot. Avoids strange line features. Defaults to \code{padding=0.1}.}

\item{warn}{Whether or not to warn if some recommended R packages are not available.}

\item{currents}{If set to TRUE (the default), the user will be asked if they want to browse a map of ocean currents. If the user responds 'y', an Internet browser window will be opened pointing to a zoomed-in map of ocean currents (at 50 m depth). The ocean currents are from 'earth.nullschool.net' and are based on an ocean circulation model which is updated daily. Owing to limitations of the website, the shell locations cannot currently be added to the page itself.}
}
\value{
A plot and the relevant dR values.
}
\description{
Find the shells that fit within a rectangular region (bounded by N, E, S and W), and plot the dR values and feeding ecology. Uses the marine database downloaded (30 Aug 2024) from calib.org/marine. See Reimer PJ, Reimer RW, 2001. A marine reservoir correction database and on-line interface. Radiocarbon 43:461-3. Expects the coordinates for the map to be provided (starting south, then clockwise as with R axes).
}
\details{
This function uses the `rnaturalearth` package for country maps. If the high-resolution maps are desired,
the `rnaturalearthhires` package must be installed from GitHub.
}
\examples{
 N_UK <- map.shells(53, -11, 60, 2, mapsize="small")
 mean(N_UK$dR)
}
