% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.R, R/kinshipX.R
\name{kinship}
\alias{kinship}
\alias{kinshipX}
\title{Kinship coefficients}
\usage{
kinship(x, ids = NULL)

kinshipX(x, ids = NULL)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{ids}{Either a character of length 2, or NULL. In the former case, it
must contain the ID labels of two members of \code{x}, and the function will
return their kinship coefficient as a single number. If \code{ids} is NULL (this
is the default), the output is the complete kinship matrix.}
}
\value{
If \code{ids = NULL}, a symmetric matrix containing all pairwise kinship
coefficients in \code{x}. If \code{ids} has length 2, the function returns a single
number.
}
\description{
Compute the matrix of kinship coefficients (autosomal or X) of all members of
a pedigree. The founders may be inbred; see \code{\link[pedtools:founderInbreeding]{pedtools::founderInbreeding()}}
for how to set this up.
}
\details{
For two (not necessarily distinct) members A, B of a pedigree, their
autosomal (resp. X) \emph{kinship coefficient} is defined as the probability that
random alleles sampled from A and B at the same autosomal (resp. X) locus,
are identical by descent relative to the pedigree.
}
\examples{
# Kinship coefficients in a nuclear family with two children
x = nuclearPed(2)
kinship(x)

# X chromosomal kinship coefficients in the same family
kinshipX(x)

# Recalculate the autosomal kinships if the father is 100\% inbred
founderInbreeding(x, 1) = 1
kinship(x)

}
\seealso{
\code{\link[=inbreeding]{inbreeding()}}, \code{\link[=kappa]{kappa()}}
}
