% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trace.R
\name{plot.riAFTBART_estimate}
\alias{plot.riAFTBART_estimate}
\title{Plot the Trace plots for the paramters from a fitted riAFT-BART model}
\usage{
\method{plot}{riAFTBART_estimate}(x, focus = "sigma", id = NULL, ...)
}
\arguments{
\item{x}{A fitted object of from riAFTBART_estimate function.}

\item{focus}{A character specifying which parameter to plot.}

\item{id}{A numeric vector indicating the subject or cluster index to plot}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A plot
}
\description{
This function create the trace plots for the parameters from a fitted riAFT-BART model.
}
\examples{
\donttest{
library(riAFTBART)
set.seed(20181223)
n = 50      # number of clusters
k = 50      # cluster size
N = n*k     # total sample size
cluster.id = rep(1:n, each=k)
tau.error = 0.8
b = stats::rnorm(n, 0, tau.error)
alpha = 2
beta1 = 1
beta2 = -1
sig.error = 0.5
censoring.rate = 0.02
x1 = stats::rnorm(N,0.5,1)
x2 = stats::rnorm(N,1.5,0.5)
trt.train = sample(c(1,2,3), N, prob = c(0.4,0.3,0.2), replace = TRUE)
trt.test = sample(c(1,2,3), N, prob = c(0.3,0.4,0.2), replace = TRUE)
error = stats::rnorm(N,0,sig.error)
logtime = alpha + beta1*x1 + beta2*x2 + b[cluster.id] + error
y = exp(logtime)
C = rexp(N, rate=censoring.rate) # censoring times
Y = pmin(y,C)
status = as.numeric(y<=C)
res <- riAFTBART_fit(M.burnin = 50, M.keep = 50, M.thin = 1, status = status,
                      y.train = Y, trt.train = trt.train, trt.test = trt.test,
                      x.train = cbind(x1,x2),
                      x.test = cbind(x1,x2),
                      cluster.id = cluster.id)
plot(x = res, focus = "sigma")
}
}
