% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{SpectralBiclustering}
\alias{SpectralBiclustering}
\title{Performs clustering according to the spectral biclustering algorithm}
\description{
This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.SpectralBiclustering.html#sklearn.cluster.SpectralBiclustering}{sklearn.cluster.SpectralBiclustering}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- SpectralBiclustering$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{SpectralBiclustering}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpectralBiclustering-new}{\code{SpectralBiclustering$new()}}
\item \href{#method-SpectralBiclustering-clone}{\code{SpectralBiclustering$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpectralBiclustering-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpectralBiclustering-new}{}}}
\subsection{Method \code{new()}}{
The \link{SpectralBiclustering} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpectralBiclustering$new(
  n_clusters = 3L,
  method = c("bistochastic", "scale", "log"),
  n_components = 6L,
  n_best = 3L,
  svd_method = c("randomized", "arpack"),
  n_svd_vecs = NULL,
  mini_batch = FALSE,
  init = c("k-means++", "random"),
  n_init = 10L,
  random_state = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_clusters}}{An integer value or a length-2 vector specifying the
number of row and column clusters in the checkerboard structure.
Defaults to \code{3L}.}

\item{\code{method}}{A string specifying the method of normalizing and
converting singular vectors into biclusters. May be one of \code{"scale"},
\code{"bistochastic"} or \code{"log"}. The authors recommend using \code{"log"}. If
the data is sparse, however, log-normalization will not work, which is
why the default is \code{"bistochastic"}. Warning: if \code{method == "log"}, the
data must not be sparse.}

\item{\code{n_components}}{An integer value specifying the number of singular
vectors to check. Defaults to \code{6L}.}

\item{\code{n_best}}{An integer value specifying the number of best singular
vectors to which to project the data for clustering. Defaults to \code{3L}.}

\item{\code{svd_method}}{A string specifying the algorithm for finding singular
vectors. May be \code{"randomized"} or \code{"arpack"}. If \code{"randomized"}, uses
\code{randomized_svd()}, which may be faster for large matrices. If
\code{"arpack"}, uses \code{scipy.sparse.linalg.svds()}, which is more accurate,
but possibly slower in some cases. Defaults to \code{"randomized"}.}

\item{\code{n_svd_vecs}}{An integer value specifying the number of vectors to
use in calculating the SVD. Corresponds to \code{ncv} when \code{svd_method == "arpack"} and \code{n_oversamples} when \code{svd_method == "randomized"}.
Defaults to \code{NULL}.}

\item{\code{mini_batch}}{A boolean value specifying whether to use mini-batch
k-means, which is faster but may get different results. Defaults to
\code{FALSE}.}

\item{\code{init}}{A string specifying the method for initialization of k-means
algorithm. Choices are \code{"k-means++"} or \code{"random"}. Defaults to
\code{"k-means++"}.}

\item{\code{n_init}}{An integer value specifying the number of random
initializations that are tried with the k-means algorithm. If
mini-batch k-means is used, the best initialization is chosen and the
algorithm runs once. Otherwise, the algorithm is run for each
initialization and the best solution chosen. Defaults to \code{10L}.}

\item{\code{random_state}}{An integer value specifying a pseudo random number
generator used for the initialization of the \code{lobpcg} eigenvectors
decomposition when \code{eigen_solver == "amg"}, and for the k-means
initialization. Defaults to \code{NULL} which uses clock time.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{SpectralBiclustering}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpectralBiclustering-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpectralBiclustering-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpectralBiclustering$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
