% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-metrics.R
\name{SlicedWassersteinDistance}
\alias{SlicedWassersteinDistance}
\title{Metrics: Sliced Wasserstein Distance}
\description{
Computes the sliced Wasserstein distance matrix from a list of
persistence diagrams. The Sliced Wasserstein distance is computed by
projecting the persistence diagrams onto lines, comparing the projections
with the 1-norm, and finally integrating over all possible lines. See
http://proceedings.mlr.press/v70/carriere17a.html for more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
dis <- SlicedWassersteinDistance$new()
dis$apply(dgm, dgm)
dis$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:MetricStep]{rgudhi::MetricStep}} -> \code{SlicedWassersteinDistance}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SlicedWassersteinDistance-new}{\code{SlicedWassersteinDistance$new()}}
\item \href{#method-SlicedWassersteinDistance-clone}{\code{SlicedWassersteinDistance$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="apply"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-apply'><code>rgudhi::MetricStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="fit"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-fit'><code>rgudhi::MetricStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="fit_transform"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-fit_transform'><code>rgudhi::MetricStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="transform"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-transform'><code>rgudhi::MetricStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SlicedWassersteinDistance-new"></a>}}
\if{latex}{\out{\hypertarget{method-SlicedWassersteinDistance-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{SlicedWassersteinDistance}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlicedWassersteinDistance$new(num_directions = 10, n_jobs = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_directions}}{An integer value specifying the number of lines
evenly sampled from \eqn{[-\pi/2,\pi/2]} in order to approximate and
speed up the kernel computation. Defaults to \code{10L}.}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SlicedWassersteinDistance}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SlicedWassersteinDistance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SlicedWassersteinDistance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SlicedWassersteinDistance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
