% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-vector-methods.R
\name{Atol}
\alias{Atol}
\title{Vector Representation: Atol}
\description{
Computes measure vectorization (e.g. point clouds, persistence
diagrams, etc.) after a quantisation step according to the Atol algorithm
\insertCite{royer2021atol}{rgudhi}.
\subsection{References}{

\insertCited{}
}
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
km <- KMeans$new(n_clusters = 2, random_state = 202006)
vr <- Atol$new(quantiser = km)
# vr$apply(dgm) # TODO: needs fix in python
vr$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:VectorRepresentationStep]{rgudhi::VectorRepresentationStep}} -> \code{Atol}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Atol-new}{\code{Atol$new()}}
\item \href{#method-Atol-clone}{\code{Atol$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="apply"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-apply'><code>rgudhi::VectorRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit'><code>rgudhi::VectorRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit_transform'><code>rgudhi::VectorRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-transform'><code>rgudhi::VectorRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Atol-new"></a>}}
\if{latex}{\out{\hypertarget{method-Atol-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Atol}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Atol$new(
  quantiser,
  weighting_method = c("cloud", "iidproba"),
  contrast = c("gaussian", "laplacian", "indicator")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quantiser}}{An object of class \code{\link{BaseClustering}} specifying
any clustering algorithm from the
\href{https://scikit-learn.org/stable/modules/classes.html#module-sklearn.cluster}{\strong{sklearn.cluster}}
module. It will be fitted when the \verb{$fit()} method is called.}

\item{\code{weighting_method}}{A string specifying the constant generic function
for weighting the measure points. Choices are either \code{"cloud"} or
\code{"iidproba"}. Defaults to \code{"cloud"}, i.e. the measure is seen as a
point cloud. This will have no impact if weights are provided along
with measures all the way, i.e. at \verb{$fit()} and \verb{$transform()} calls,
through the optional argument \code{sample_weight}.}

\item{\code{contrast}}{A string specifying the constant function for evaluating
proximity of a measure with respect to centers. Choices are either
\code{"gaussian"} or \code{"laplacian"} or \code{"indicator"}. Defaults to
\code{"gaussian"} (see page 3 in
\insertCite{royer2021atol;textual}{rgudhi}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Atol}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Atol-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Atol-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Atol$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
