### * <HEADER>
###
attach(NULL, name = "CheckExEnv")
assign("nameEx", 
       local({
	   s <- "__{must remake R-ex/*.R}__"
           function(new) {
               if(!missing(new)) s <<- new else s
           }
       }),
       pos = "CheckExEnv")
## Add some hooks to label plot pages for base and grid graphics
assign("base_plot_hook",
       function() {
           pp <- par(c("mfg","mfcol","oma","mar"))
           if(all(pp$mfg[1:2] == c(1, pp$mfcol[2]))) {
               outer <- (oma4 <- pp$oma[4]) > 0; mar4 <- pp$mar[4]
               mtext(sprintf("help(\"%s\")", nameEx()), side = 4,
                     line = if(outer)max(1, oma4 - 1) else min(1, mar4 - 1),
              outer = outer, adj = 1, cex = .8, col = "orchid", las=3)
           }
       },
       pos = "CheckExEnv")
assign("grid_plot_hook",
       function() {
           pushViewport(viewport(width=unit(1, "npc") - unit(1, "lines"),
                                 x=0, just="left"))
           grid.text(sprintf("help(\"%s\")", nameEx()),
                     x=unit(1, "npc") + unit(0.5, "lines"),
                     y=unit(0.8, "npc"), rot=90,
                     gp=gpar(col="orchid"))
       },
       pos = "CheckExEnv")
setHook("plot.new",     get("base_plot_hook", pos = "CheckExEnv"))
setHook("persp",        get("base_plot_hook", pos = "CheckExEnv"))
setHook("grid.newpage", get("grid_plot_hook", pos = "CheckExEnv"))
assign("cleanEx",
       function(env = .GlobalEnv) {
	   rm(list = ls(envir = env, all.names = TRUE), envir = env)
           RNGkind("default", "default")
	   set.seed(1)
   	   options(warn = 1)
	   .CheckExEnv <- as.environment("CheckExEnv")
	   delayedAssign("T", stop("T used instead of TRUE"),
		  assign.env = .CheckExEnv)
	   delayedAssign("F", stop("F used instead of FALSE"),
		  assign.env = .CheckExEnv)
	   sch <- search()
	   newitems <- sch[! sch %in% .oldSearch]
	   for(item in rev(newitems))
               eval(substitute(detach(item), list(item=item)))
	   missitems <- .oldSearch[! .oldSearch %in% sch]
	   if(length(missitems))
	       warning("items ", paste(missitems, collapse=", "),
		       " have been removed from the search path")
       },
       pos = "CheckExEnv")
assign("ptime", proc.time(), pos = "CheckExEnv")
grDevices::postscript("rgl-Ex.ps")
assign("par.postscript", graphics::par(no.readonly = TRUE), pos = "CheckExEnv")
options(contrasts = c(unordered = "contr.treatment", ordered = "contr.poly"), pager="console")
options(warn = 1)    
library('rgl')

assign(".oldSearch", search(), pos = 'CheckExEnv')
assign(".oldNS", loadedNamespaces(), pos = 'CheckExEnv')
cleanEx(); nameEx("3dobjects");
### * 3dobjects

flush(stderr()); flush(stdout())

### Name: points3d
### Title: add primitive set shape
### Aliases: points3d lines3d segments3d triangles3d quads3d
### Keywords: dynamic

### ** Examples

# Show 12 random vertices in various ways. 

M <- matrix(rnorm(36), 3, 12, dimnames=list(c('x','y','z'), 
                                       rep(LETTERS[1:4], 3)))

# Force 4-tuples to be convex in planes so that quads3d works.

for (i in c(1,5,9)) {
    quad <- as.data.frame(M[,i+0:3])
    coeffs <- runif(2,0,3)
    if (mean(coeffs) < 1) coeffs <- coeffs + 1 - mean(coeffs)
    quad$C <- with(quad, coeffs[1]*(B-A) + coeffs[2]*(D-A) + A)
    M[,i+0:3] <- as.matrix(quad)
}

open3d()

# Rows of M are x, y, z coords; transpose to plot

M <- t(M)
shift <- matrix(c(-3,3,0), 12, 3, byrow=TRUE)

points3d(M, size=2)
lines3d(M + shift)
segments3d(M + 2*shift)
triangles3d(M + 3*shift, col='red')
quads3d(M + 4*shift, col='green')  
text3d(M + 5*shift, texts=1:12)

# Add labels

shift <- outer(0:5, shift[1,])
shift[,1] <- shift[,1] + 3
text3d(shift, 
       texts = c('points3d','lines3d','segments3d',
         'triangles3d', 'quads3d','text3d'),
       adj = 0)
 rgl.bringtotop()



cleanEx(); nameEx("aspect3d");
### * aspect3d

flush(stderr()); flush(stdout())

### Name: aspect3d
### Title: Set the aspect ratios of the current plot
### Aliases: aspect3d
### Keywords: dynamic

### ** Examples

  x <- rnorm(100)
  y <- rnorm(100)*2
  z <- rnorm(100)*3
  
  open3d()
  plot3d(x, y, z)
  aspect3d(1,1,0.5)
  open3d()
  plot3d(x, y, z)
  aspect3d("iso")



cleanEx(); nameEx("axes3d");
### * axes3d

flush(stderr()); flush(stdout())

### Name: axes3d
### Title: Draw boxes, axes and other text outside the data
### Aliases: axes3d axis3d mtext3d title3d box3d
### Keywords: dynamic

### ** Examples

  open3d()
  points3d(rnorm(10),rnorm(10),rnorm(10), size=3)

  # First add standard axes
  axes3d()  

  # and one in the middle (the NA will be ignored, a number would 
  # do as well)
  axis3d('x',pos=c(NA, 0, 0))

  # add titles
  title3d('main','sub','xlab','ylab','zlab')

  rgl.bringtotop()
  
  open3d()
  points3d(rnorm(10),rnorm(10),rnorm(10), size=3)
  
  # Use fixed axes
  
  axes3d(c('x','y','z'))
         
  # Put 4 x-axes on the plot
  axes3d(c('x--','x-+','x+-','x++'))         
  
  axis3d('x',pos=c(NA, 0, 0))     
  title3d('main','sub','xlab','ylab','zlab')



cleanEx(); nameEx("bbox");
### * bbox

flush(stderr()); flush(stdout())

### Name: rgl.bbox
### Title: Set up Bounding Box decoration
### Aliases: rgl.bbox bbox3d
### Keywords: dynamic

### ** Examples

  rgl.open()
  rgl.points(rnorm(100), rnorm(100), rnorm(100))
  rgl.bbox(color=c("#333377","white"), emission="#333377", 
           specular="#3333FF", shininess=5, alpha=0.8 )
  
  open3d()
  points3d(rnorm(100), rnorm(100), rnorm(100))
  bbox3d(color=c("#333377","white"), emission="#333377", 
         specular="#3333FF", shininess=5, alpha=0.8)



cleanEx(); nameEx("bg");
### * bg

flush(stderr()); flush(stdout())

### Name: bg
### Title: Set up Background
### Aliases: rgl.bg bg3d
### Keywords: dynamic

### ** Examples

  rgl.open()
  
  # a simple white background
  
  bg3d("white")

  # the holo-globe (inspired by star trek):

  rgl.bg(sphere=TRUE, color=c("black","green"), lit=FALSE, back="lines" )

  # an environmental sphere with a nice texture.

  rgl.bg(sphere=TRUE, texture=system.file("textures/sunsleep.png", package="rgl"), 
         back="filled" )



cleanEx(); nameEx("ellipse3d");
### * ellipse3d

flush(stderr()); flush(stdout())

### Name: ellipse3d
### Title: Make an ellipsoid
### Aliases: ellipse3d ellipse3d.default ellipse3d.lm ellipse3d.glm
###   ellipse3d.nls
### Keywords: dplot

### ** Examples

# Plot a random sample and an ellipsoid of concentration corresponding to a 95% 
# probability region for a
# trivariate normal distribution with mean 0, unit variances and 
# correlation 0.8.
if (require(MASS)) {
  Sigma <- matrix(c(10,3,0,3,2,0,0,0,1), 3,3)
  Mean <- 1:3
  x <- mvrnorm(1000, Mean, Sigma)
  
  open3d()
  
  plot3d(x, size=3, box=FALSE)
  
  plot3d( ellipse3d(Sigma, centre=Mean), col="green", alpha=0.5, add = TRUE)
}  

# Plot the estimate and joint 90% confidence region for the displacement and cylinder
# count linear coefficients in the mtcars dataset

data(mtcars)
fit <- lm(mpg ~ disp + cyl , mtcars)

open3d()
plot3d(ellipse3d(fit, level = 0.90), col="blue", alpha=0.5, aspect=TRUE)



cleanEx(); nameEx("grid3d");
### * grid3d

flush(stderr()); flush(stdout())

### Name: grid3d
### Title: Add a grid to a 3D plot
### Aliases: grid3d
### Keywords: dynamic

### ** Examples

x <- 1:10
y <- 1:10
z <- matrix(outer(x-5,y-5) + rnorm(100), 10, 10)
open3d()
persp3d(x, y, z, col="red", alpha=0.7, aspect=c(1,1,0.5))
grid3d(c("x", "y+", "z"))



cleanEx(); nameEx("material");
### * material

flush(stderr()); flush(stdout())

### Name: rgl.material
### Title: Generic Appearance setup
### Aliases: rgl.material material3d
### Keywords: dynamic

### ** Examples

save <- material3d("color")
material3d(color="red")
material3d("color")
material3d(color=save)



cleanEx(); nameEx("matrices");
### * matrices

flush(stderr()); flush(stdout())

### Name: matrices
### Title: Work with homogeneous coordinates
### Aliases: matrices identityMatrix scaleMatrix translationMatrix
###   rotationMatrix scale3d translate3d rotate3d transform3d asHomogeneous
###   asEuclidean
### Keywords: dynamic

### ** Examples

# A 90 degree rotation about the x axis:

rotationMatrix(pi/2, 1, 0, 0)

# Find what happens when you rotate (2,0,0) by 45 degrees about the y axis:

x <- asHomogeneous(c(2,0,0))
y <- x 
asEuclidean(y)

# or more simply...

rotate3d(c(2,0,0), pi/4, 0, 1, 0)




cleanEx(); nameEx("par3d");
### * par3d

flush(stderr()); flush(stdout())

### Name: par3d
### Title: Set or Query RGL Parameters
### Aliases: par3d open3d r3dDefaults
### Keywords: dynamic

### ** Examples

    r3dDefaults
    open3d()
    shade3d(cube3d(color=rep(rainbow(6),rep(4,6))))
    save <- par3d(userMatrix = rotationMatrix(90*pi/180, 1,0,0))
    save
    par3d("userMatrix")    
    par3d(save)
    par3d("userMatrix")



cleanEx(); nameEx("persp3d");
### * persp3d

flush(stderr()); flush(stdout())

### Name: persp3d
### Title: Surface plots
### Aliases: persp3d persp3d.default
### Keywords: dynamic

### ** Examples


# (1) The Obligatory Mathematical surface.
#     Rotated sinc function.

x <- seq(-10, 10, length= 30)
y <- x
f <- function(x,y) { r <- sqrt(x^2+y^2); 10 * sin(r)/r }
z <- outer(x, y, f)
z[is.na(z)] <- 1
open3d()
bg3d("white")
material3d(col="black")
persp3d(x, y, z, aspect=c(1, 1, 0.5), col = "lightblue",
        xlab = "X", ylab = "Y", zlab = "Sinc( r )")

# (2) Add to existing persp plot:

xE <- c(-10,10); xy <- expand.grid(xE, xE)
points3d(xy[,1], xy[,2], 6, col = 2, size = 3)
lines3d(x, y=10, z= 6 + sin(x), col = 3)

phi <- seq(0, 2*pi, len = 201)
r1 <- 7.725 # radius of 2nd maximum
xr <- r1 * cos(phi)
yr <- r1 * sin(phi)
lines3d(xr,yr, f(xr,yr), col = "pink", size = 2)

# (3) Visualizing a simple DEM model

z <- 2 * volcano        # Exaggerate the relief
x <- 10 * (1:nrow(z))   # 10 meter spacing (S to N)
y <- 10 * (1:ncol(z))   # 10 meter spacing (E to W)

open3d()
bg3d("slategray")
material3d(col="black")
persp3d(x, y, z, col = "green3", aspect="iso",
      axes = FALSE, box = FALSE)



cleanEx(); nameEx("plot3d");
### * plot3d

flush(stderr()); flush(stdout())

### Name: plot3d
### Title: 3D Scatterplot
### Aliases: plot3d plot3d.default plot3d.qmesh3d decorate3d
### Keywords: dynamic

### ** Examples

  open3d()
  x <- sort(rnorm(1000))
  y <- rnorm(1000)
  z <- rnorm(1000) + atan2(x,y)
  plot3d(x, y, z, col=rainbow(1000), size=2)



cleanEx(); nameEx("postscript");
### * postscript

flush(stderr()); flush(stdout())

### Name: rgl.postscript
### Title: export screenshot
### Aliases: rgl.postscript
### Keywords: dynamic

### ** Examples


## Not run: 
##D 
##D #
##D # create a series of frames for an animation
##D #
##D 
##D rgl.open()
##D shade3d(oh3d(), color="red")
##D rgl.viewpoint(0,20)
##D 
##D for (i in 1:45) {
##D   rgl.viewpoint(i,20)
##D   filename <- paste("pic",formatC(i,digits=1,flag="0"),".eps",sep="") 
##D   rgl.postscript(filename, fmt="eps")
##D }
##D 
## End(Not run)




cleanEx(); nameEx("primitive");
### * primitive

flush(stderr()); flush(stdout())

### Name: rgl.primitive
### Title: add primitive set shape
### Aliases: rgl.primitive rgl.points rgl.lines rgl.linestrips
###   rgl.triangles rgl.quads
### Keywords: dynamic

### ** Examples

rgl.open()
rgl.points(rnorm(1000), rnorm(1000), rnorm(1000), color=heat.colors(1000), size=2)



cleanEx(); nameEx("qmesh3d");
### * qmesh3d

flush(stderr()); flush(stdout())

### Name: qmesh3d
### Title: 3D Quadrangle Mesh objects
### Aliases: qmesh3d dot3d dot3d.qmesh3d wire3d wire3d.qmesh3d shade3d
###   shade3d.qmesh3d cube3d oh3d
### Keywords: dynamic

### ** Examples


  # generate a quad mesh object

  vertices <- c( 
     -1.0, -1.0, 0, 1.0,
      1.0, -1.0, 0, 1.0,
      1.0,  1.0, 0, 1.0,
     -1.0,  1.0, 0, 1.0
  )
  indices <- c( 1, 2, 3, 4 )
  
  open3d()  
  wire3d( qmesh3d(vertices,indices) )
  
  # render 4 meshes vertically in the current view

  open3d()  
  bg3d("gray")
  l0 <- oh3d(tran = par3d("userMatrix"), color = "green" )
  shade3d( translate3d( l0, -6, 0, 0 ))
  l1 <- subdivision3d( l0 )
  shade3d( translate3d( l1 , -2, 0, 0 ), color="red", override = FALSE )
  l2 <- subdivision3d( l1 )
  shade3d( translate3d( l2 , 2, 0, 0 ), color="red", override = TRUE )
  l3 <- subdivision3d( l2 )
  shade3d( translate3d( l3 , 6, 0, 0 ), color="red" )
  



cleanEx(); nameEx("r3d");
### * r3d

flush(stderr()); flush(stdout())

### Name: r3d
### Title: Generic 3D interface
### Aliases: r3d
### Keywords: dynamic

### ** Examples

    
     x <- c(0,1,0,0)
     y <- c(0,0,1,0)
     z <- c(0,0,0,1)
     labels <- c("Origin", "X", "Y", "Z")
     i <- c(1,2,1,3,1,4)

     rgl.open()
     rgl.texts(x,y,z,labels)
     rgl.texts(1,1,1,"rgl.* coordinates")
     rgl.lines(x[i],y[i],z[i])

     open3d()
     text3d(x,y,z,labels)
     text3d(1,1,1,"*3d coordinates")
     segments3d(x[i],y[i],z[i])



cleanEx(); nameEx("rgl-package");
### * rgl-package

flush(stderr()); flush(stdout())

### Name: rgl-package
### Title: 3D visualization device system
### Aliases: rgl-package rgl rgl.open rgl.close rgl.cur rgl.set rgl.quit
### Keywords: dynamic

### ** Examples

example(surface3d)
example(plot3d)



cleanEx(); nameEx("rgl.bringtotop");
### * rgl.bringtotop

flush(stderr()); flush(stdout())

### Name: rgl.bringtotop
### Title: Assign focus to an RGL window
### Aliases: rgl.bringtotop
### Keywords: dynamic

### ** Examples

rgl.open()
rgl.points(rnorm(1000), rnorm(1000), rnorm(1000), color=heat.colors(1000), size=2)
rgl.bringtotop(stay = TRUE)    



cleanEx(); nameEx("rgl.user2window");
### * rgl.user2window

flush(stderr()); flush(stdout())

### Name: rgl.user2window
### Title: Convert between rgl user and window coordinates
### Aliases: rgl.user2window rgl.window2user rgl.projection
### Keywords: dynamic

### ** Examples

open3d()
points3d(rnorm(100), rnorm(100), rnorm(100))
if (interactive() || !.Platform$OS=="unix") {
# Calculate a square in the middle of the display and plot it
square <- rgl.window2user(c(0.25, 0.25, 0.75, 0.75, 0.25), 
                          c(0.25, 0.75, 0.75, 0.25, 0.25), 0.5)
par3d(ignoreExtent = TRUE)
lines3d(square)
par3d(ignoreExtent = FALSE)
}



cleanEx(); nameEx("scene");
### * scene

flush(stderr()); flush(stdout())

### Name: scene
### Title: scene management
### Aliases: rgl.clear rgl.pop clear3d pop3d rgl.ids
### Keywords: dynamic

### ** Examples

  x <- rnorm(100)
  y <- rnorm(100)
  z <- rnorm(100)
  p <- plot3d(x, y, z, type='s')
  rgl.ids()
  lines3d(x, y, z)
  rgl.ids()
  if (interactive()) {
    readline("Hit enter to change spheres")
    rgl.pop(id = p[c("data", "box.lines")])
    spheres3d(x, y, z, col="red", radius=1/5)
    box3d()
  }



cleanEx(); nameEx("select3d");
### * select3d

flush(stderr()); flush(stdout())

### Name: select3d
### Title: Select a rectangle in an RGL scene
### Aliases: select3d rgl.select3d
### Keywords: dynamic

### ** Examples


# Allow the user to select some points, and then redraw them
# in a different color

if (interactive()) {
 x <- rnorm(1000)
 y <- rnorm(1000)
 z <- rnorm(1000)
 open3d()
 points3d(x,y,z,size=2)
 f <- select3d()
 keep <- f(x,y,z)
 rgl.pop()
 points3d(x[keep],y[keep],z[keep],size=2,color='red')
 points3d(x[!keep],y[!keep],z[!keep],size=2)
}



cleanEx(); nameEx("snapshot");
### * snapshot

flush(stderr()); flush(stdout())

### Name: rgl.snapshot
### Title: export screenshot
### Aliases: rgl.snapshot snapshot3d
### Keywords: dynamic

### ** Examples


## Not run: 
##D 
##D #
##D # create animation
##D #
##D 
##D shade3d(oh3d(), color="red")
##D rgl.viewpoint(0,20)
##D 
##D setwd(tempdir())
##D for (i in 1:45) {
##D   rgl.viewpoint(i,20)
##D   filename <- paste("pic",formatC(i,digits=1,flag="0"),".png",sep="")
##D   rgl.snapshot(filename)
##D }
##D ## Now run ImageMagick command:
##D ##    convert -delay 10 *.png -loop 0 pic.gif
## End(Not run)




cleanEx(); nameEx("spheres");
### * spheres

flush(stderr()); flush(stdout())

### Name: spheres
### Title: add sphere set shape
### Aliases: rgl.spheres spheres3d
### Keywords: dynamic

### ** Examples

open3d()
spheres3d(rnorm(10), rnorm(10), rnorm(10), radius=runif(10), color=rainbow(10))



cleanEx(); nameEx("sprites");
### * sprites

flush(stderr()); flush(stdout())

### Name: sprites
### Title: add sprite set shape
### Aliases: sprites3d particles3d rgl.sprites
### Keywords: dynamic

### ** Examples

open3d()
particles3d( rnorm(100), rnorm(100), rnorm(100), color=rainbow(100) )
# is the same as
sprites3d( rnorm(100), rnorm(100), rnorm(100), color=rainbow(100),
  lit=FALSE, alpha=.2,
  textype="alpha", texture=system.file("textures/particle.png", package="rgl") )



cleanEx(); nameEx("subdivision3d");
### * subdivision3d

flush(stderr()); flush(stdout())

### Name: subdivision3d
### Title: generic subdivision surface method
### Aliases: subdivision3d subdivision3d.qmesh3d divide.qmesh3d
###   normalize.qmesh3d deform.qmesh3d
### Keywords: dynamic

### ** Examples

  open3d()
  shade3d( subdivision3d( cube3d(), depth=3 ), color="red", alpha=0.5 )



cleanEx(); nameEx("surface");
### * surface

flush(stderr()); flush(stdout())

### Name: rgl.surface
### Title: add height-field surface shape
### Aliases: rgl.surface
### Keywords: dynamic

### ** Examples


#
# volcano example taken from "persp"
#

data(volcano)

y <- 2 * volcano        # Exaggerate the relief

x <- 10 * (1:nrow(y))   # 10 meter spacing (S to N)
z <- 10 * (1:ncol(y))   # 10 meter spacing (E to W)

ylim <- range(y)
ylen <- ylim[2] - ylim[1] + 1

colorlut <- terrain.colors(ylen) # height color lookup table

col <- colorlut[ y-ylim[1]+1 ] # assign colors to heights for each point

rgl.open()
rgl.surface(x, z, y, color=col, back="lines")




cleanEx(); nameEx("surface3d");
### * surface3d

flush(stderr()); flush(stdout())

### Name: surface3d
### Title: add height-field surface shape
### Aliases: surface3d terrain3d
### Keywords: dynamic

### ** Examples


#
# volcano example taken from "persp"
#

data(volcano)

z <- 2 * volcano        # Exaggerate the relief

x <- 10 * (1:nrow(z))   # 10 meter spacing (S to N)
y <- 10 * (1:ncol(z))   # 10 meter spacing (E to W)

zlim <- range(y)
zlen <- zlim[2] - zlim[1] + 1

colorlut <- terrain.colors(zlen) # height color lookup table

col <- colorlut[ z-zlim[1]+1 ] # assign colors to heights for each point

open3d()
surface3d(x, y, z, color=col, back="lines")




cleanEx(); nameEx("texts");
### * texts

flush(stderr()); flush(stdout())

### Name: texts
### Title: add text
### Aliases: rgl.texts text3d texts3d
### Keywords: dynamic

### ** Examples

open3d()
text3d(rnorm(10)*100,rnorm(10)*100,rnorm(10)*100,text=1:10,adj = 0.5, 
       color=heat.colors(10))



cleanEx(); nameEx("viewpoint");
### * viewpoint

flush(stderr()); flush(stdout())

### Name: viewpoint
### Title: Set up viewpoint
### Aliases: rgl.viewpoint view3d
### Keywords: dynamic

### ** Examples


# animated round trip tour for 10 seconds

rgl.open()
shade3d(oh3d(), color="red")

start <- proc.time()[3]
while ((i <- 36*(proc.time()[3]-start)) < 360) {
  rgl.viewpoint(i,i/4); 
}




### * <FOOTER>
###
cat("Time elapsed: ", proc.time() - get("ptime", pos = 'CheckExEnv'),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
