% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_record.R
\name{parse_record}
\alias{parse_record}
\title{Calculate flags for a single record}
\usage{
parse_record(record = NULL, decimalLatitude = NULL,
  decimalLongitude = NULL, countryCode = NULL, scientificName = NULL, ...)
}
\arguments{
\item{record}{List-type object containing information on the record. If
present, it MUST contain the following four attributes as named elements.}

\item{decimalLatitude}{Only if 'record' is not present. Latitude in decimal
degrees format (float, e.g. 42.1833)}

\item{decimalLongitude}{Only if 'record' is not present. Longitude in decimal
degrees format (float, e.g. -1.8332)}

\item{countryCode}{Only if 'record' is not present. Two or three-letter
ISO-3166 country codes (string, e.g. "ES")}

\item{scientificName}{Only if 'record' is not present. Binomial identifying
the species (string, e.g. "Puma concolor")}

\item{...}{Any extra parameters for \code{httr} \code{\link{GET}}}
}
\value{
A named list with the geospatial quality flags
}
\description{
\code{parse_record} calls the \code{GET} method of the API in order to
extract the flags for an individual record. It returns just the \code{flags}
element.
}
\details{
Data can be passed in two different ways to this function: either with the
four key elements (\code{decimalLatitude}, \code{decimalLongitude},
\code{countryCode} and \code{scientificName}) passed as named arguments or
via a single \code{record} parameter that consists of a list with these four
elements. However, if both are filled, the function will stop and show an
error message. The more filled fields, the more informative the output of the
API will be. However, due to the flexible nature of the underlying API, a
valid response will be get even if no input data is provided. Therefore,
calling \code{parse_record()} with no arguments will return a list of three
\code{FALSE} elements, which represents no information at all. The function
will however throw a warning for each missing field. See \code{\link{flags}}
for more info on the input and output of the function.
}
\examples{
\dontrun{
# Using the 'record' parameter
# Create 'record' object with values
rec <- list(decimalLatitude=42.1833, decimalLongitude=-1.8332,
            countryCode="ES", scientificName="Puma concolor")
# Call the API and get the results
parse_record(record=rec)

# Using named arguments
parse_record(decimalLatitude=42.1833, decimalLongitude=-1.8332,
           countryCode="ES", scientificName="Puma concolor")
# In both cases, the result will be the same

# If any parameter is missing, the function runs, but throws a warning
# message. This will throw a warning saying that 'countryCode' and
# 'scientificName' fields are missing. Also, the results will be
# limited to the feasible calculations.
parse_record(decimalLatitude=42.1833, decimalLongitude=-1.8332)

# One can call the function without parameters. Although valid,
# this way of calling the function is useless.
parse_record()
}
}
\seealso{
\code{\link{flags}}, \code{\link{add_flags}}
}

