% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_orderbook.R
\name{public_orderbook}
\alias{public_orderbook}
\title{Get bids and asks for provided currency-pair (products) by GDAX.}
\usage{
public_orderbook(product_id = "LTC-USD", level = 1)
}
\arguments{
\item{product_id}{Optional character parameter. This is a case insensitive value of the product id for which the order book is desired. Default to \code{'LTC-USD'}. For all valid product ids, refer to \code{\link{public_info}}.}

\item{level}{Optional parameter. Integer value of level denoting level of detail. Valid user values of 1, 2, 3. Default to 1.}
}
\value{
A named list with bids and asks for the provided currency pair.
}
\description{
This function is a public function and will fetch all bids/asks for provided currency pair (product_id). User should change the level to get the best bid/ask or to fetch all bids/asks.
}
\examples{
\dontrun{
public_orderbook()
public_orderbook(product_id = "BCH-USD", level = 3)
public_orderbook(product_id = "BTC-EUR", level = 2)
}

}
