% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installation_uuid_funs.R
\name{installation_uuid_funs}
\alias{installation_uuid_funs}
\alias{installation_dataset}
\alias{installation_comment}
\alias{installation_contact}
\alias{installation_endpoint}
\alias{installation_identifier}
\alias{installation_machinetag}
\alias{installation_tag}
\title{Get installation metadata using an installation key}
\usage{
installation_dataset(
  uuid = NULL,
  limit = 20,
  start = NULL,
  curlopts = list(http_version = 2)
)

installation_comment(uuid = NULL, curlopts = list(http_version = 2))

installation_contact(uuid = NULL, curlopts = list(http_version = 2))

installation_endpoint(uuid = NULL, curlopts = list(http_version = 2))

installation_identifier(uuid = NULL, curlopts = list(http_version = 2))

installation_machinetag(uuid = NULL, curlopts = list(http_version = 2))

installation_tag(uuid = NULL, curlopts = list(http_version = 2))
}
\arguments{
\item{uuid}{A GBIF installationKey uuid.}

\item{limit}{The number of results to return. Default is 20.}

\item{start}{The offset of the first result to return.}

\item{curlopts}{A list of curl options to pass to the request.}
}
\value{
A \code{tibble} or a \code{list}.
}
\description{
Get installation metadata using an installation key
}
\examples{
\dontrun{
# Get all datasets for a given installation 
installation_dataset(uuid="d209e552-7e6e-4840-b13c-c0596ef36e55", limit=10)
installation_comment(uuid="a0e05292-3d09-4eae-9f83-02ae3516283c")
installation_contact(uuid="896898e8-c0ac-47a0-8f38-0f792fbe3343")
installation_endpoint(uuid="896898e8-c0ac-47a0-8f38-0f792fbe3343")
installation_identifier(uuid="896898e8-c0ac-47a0-8f38-0f792fbe3343")
installation_machinetag(uuid="896898e8-c0ac-47a0-8f38-0f792fbe3343")
}

}
