% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_geocode.R
\name{gbif_geocode}
\alias{gbif_geocode}
\title{Geocode lat-lon point(s) with GBIF's set of geo-polygons (experimental)}
\usage{
gbif_geocode(
  latitude = NULL,
  longitude = NULL,
  curlopts = list(http_version = 2)
)
}
\arguments{
\item{latitude}{a vector of numeric latitude values between -90 and 90.}

\item{longitude}{a vector of numeric longitude values between -180 and 180.}

\item{curlopts}{A list of curl options to pass to the request.}
}
\value{
A data.frame of results from the GBIF gecoding service.
\itemize{
\item \strong{latitude} : The input latitude
\item \strong{longitude} : The input longitude
\item \strong{index} : The original input rownumber
\item \strong{id} : The polygon id from which the geocode comes from
\item \strong{type} : One of the following : "Political" (county codes),
"IHO" (marine regions), "SeaVox" (marine regions), "WGSRPD" (tdwg regions),
"EEZ", (in national waters) or "GADM0","GADM1","GADM2","GADM2"(http://gadm.org/)
\item \strong{title} : The name of the source polygon
\item \strong{distance} : distance to the polygon boarder
}

This function uses the GBIF geocoder API which is not guaranteed to be
stable and is undocumented. As such, this may return different data over
time, may be rate-limited or may stop working if GBIF change the service.
Use this function with caution.
}
\description{
Geocode lat-lon point(s) with GBIF's set of geo-polygons (experimental)
}
\examples{
\dontrun{
# one pair 
gbif_geocode(0,0)
# or multiple pairs of points
gbif_geocode(c(0,50),c(0,20))

}

}
\references{
http://gadm.org/
http://marineregions.org/
http://www.tdwg.org/standards/
\url{http://api.gbif.org/v1/geocode/reverse?lat=0&lng=0}
}
