% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_suggest.r
\name{dataset_suggest}
\alias{dataset_suggest}
\title{Suggest datasets in GBIF.}
\usage{
dataset_suggest(
  query = NULL,
  country = NULL,
  type = NULL,
  subtype = NULL,
  keyword = NULL,
  publishingOrg = NULL,
  hostingOrg = NULL,
  publishingCountry = NULL,
  decade = NULL,
  continent = NULL,
  limit = 100,
  start = NULL,
  pretty = FALSE,
  description = FALSE,
  curlopts = list()
)
}
\arguments{
\item{query}{Query term(s) for full text search.  The value for this
parameter can be a simple word or a phrase. Wildcards can be added to the
simple word parameters only, e.g. \code{q=*puma*}}

\item{country}{NOT YET IMPLEMENTED. Filters by country as given in
isocodes$gbif_name, e.g. \code{country="CANADA"}}

\item{type}{Type of dataset, options include occurrene, metadata, checklist,
sampling_event
(http://gbif.github.io/gbif-api/apidocs/org/gbif/api/vocabulary/DatasetType.html)}

\item{subtype}{NOT YET IMPLEMENTED. Will allow filtering of datasets by
their dataset subtypes, DC or EML.}

\item{keyword}{Keyword to search by. Datasets can be tagged by keywords,
which you can search on. The search is done on the merged collection of
tags, the dataset keywordCollections and temporalCoverages.}

\item{publishingOrg}{Publishing organization. A uuid string. See
\code{\link{organizations}}}

\item{hostingOrg}{Hosting organization. A uuid string. See
\code{\link{organizations}}}

\item{publishingCountry}{Publishing country. See options at
isocodes$gbif_name}

\item{decade}{Decade, e.g., 1980. Filters datasets by their temporal coverage
broken down to decades. Decades are given as a full year, e.g. 1880, 1960,
2000, etc, and will return datasets wholly contained in the decade as well
as those that cover the entire decade or more. Facet by decade to get the
break down, e.g. /search?facet=DECADE&facet_only=true (see example below)}

\item{continent}{Not yet implemented, but will eventually allow filtering
datasets by their continent(s) as given in our Continent enum.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{pretty}{Print informative metadata using \code{\link{cat}}. Not easy
to manipulate output though.}

\item{description}{Return descriptions only (TRUE) or all data (FALSE,
default)}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
A data.frame, list, or message printed to console (using
\code{pretty=TRUE}).
}
\description{
Suggest datasets in GBIF.
}
\section{Repeat parmeter inputs}{

Some parameters can tak emany inputs, and treated as 'OR' (e.g., a or b or
c). The following take many inputs:
\itemize{
\item \code{type}
\item \code{keyword}
\item \code{publishingOrg}
\item \code{hostingOrg}
\item \code{publishingCountry}
\item \code{decade}
}
}

\examples{
\dontrun{
# Suggest datasets of type "OCCURRENCE".
# dataset_suggest(query="Amazon", type="OCCURRENCE")

# Suggest datasets tagged with keyword "france".
# dataset_suggest(keyword="france")

# Fulltext search for all datasets having the word "amsterdam" somewhere in
# its metadata (title, description, etc).
# dataset_suggest(query="amsterdam")

# Limited search
# dataset_suggest(type="OCCURRENCE", limit=2)
# dataset_suggest(type="OCCURRENCE", limit=2, start=10)

# Return just descriptions
# dataset_suggest(type="OCCURRENCE", limit = 5, description=TRUE)

# Return metadata in a more human readable way (hard to manipulate though)
# dataset_suggest(type="OCCURRENCE", limit = 5, pretty=TRUE)

# Search by country code. Lookup isocodes first, and use US for United States
isocodes[agrep("UNITED", isocodes$gbif_name),]
# dataset_suggest(country="US", limit = 25)

# Search by decade
# dataset_suggest(decade=1980, limit = 30)

# Some parameters accept many inputs, treated as OR
# dataset_suggest(type = c("metadata", "checklist"))
# dataset_suggest(keyword = c("fern", "algae"))
# dataset_suggest(publishingOrg = c("e2e717bf-551a-4917-bdc9-4fa0f342c530",
#   "90fd6680-349f-11d8-aa2d-b8a03c50a862"))
# dataset_suggest(hostingOrg = c("c5f7ef70-e233-11d9-a4d6-b8a03c50a862",
#   "c5e4331-7f2f-4a8d-aa56-81ece7014fc8"))
# dataset_suggest(publishingCountry = c("DE", "NZ"))
# dataset_suggest(decade = c(1910, 1930))

# curl options
# dataset_suggest(type="OCCURRENCE", limit = 2, curlopts = list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/registry#datasetSearch}
}
