% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration.R
\name{enumeration}
\alias{enumeration}
\alias{enumeration_country}
\title{Enumerations.}
\usage{
enumeration(x = NULL, curlopts = list())

enumeration_country(curlopts = list())
}
\arguments{
\item{x}{A given enumeration.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\value{
\code{enumeration} returns a character vector, while
\code{enumeration_country} returns a data.frame.
}
\description{
Many parts of the GBIF API make use of enumerations, i.e. controlled
vocabularies for specific topics - and are available via these functions
}
\examples{
\dontrun{
# basic enumeration
enumeration()
enumeration("NameType")
enumeration("MetadataType")
enumeration("TypeStatus")

# country enumeration
enumeration_country()

# curl options
enumeration(curlopts = list(verbose=TRUE))
}
}
