% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_metrics.r
\name{dataset_metrics}
\alias{dataset_metrics}
\title{Get details on a GBIF dataset.}
\usage{
dataset_metrics(uuid, ...)
}
\arguments{
\item{uuid}{(character) One or more dataset UUIDs. See examples.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\description{
Get details on a GBIF dataset.
}
\examples{
\dontrun{
dataset_metrics(uuid='863e6d6b-f602-4495-ac30-881482b6f799')
dataset_metrics(uuid='66dd0960-2d7d-46ee-a491-87b9adcfe7b1')
dataset_metrics(uuid=c('863e6d6b-f602-4495-ac30-881482b6f799',
   '66dd0960-2d7d-46ee-a491-87b9adcfe7b1'))

library("httr")
dataset_metrics(uuid='66dd0960-2d7d-46ee-a491-87b9adcfe7b1', config=verbose())
}
}
\references{
\url{http://www.gbif.org/developer/registry#datasetMetrics}
}

