\name{gs_gauge_update}
\alias{gs_gauge_update}
\title{Updates and returns a gauge with the updates applied.}
\usage{
  gs_gauge_update(id = NULL,
    tz = "Eastern Time (US & Canada)", title = "foo_bar",
    allowed_hosts = NULL, keyname = "GaugesKey",
    verbose = TRUE)
}
\arguments{
  \item{id}{Id of the gauge}

  \item{title}{Title of the gauge.}

  \item{tz}{The time zone that should be used for all
  date/time operations. See here
  \url{http://api.rubyonrails.org/classes/ActiveSupport/TimeZone.html}
  for reference.}

  \item{allowed_hosts}{Comma or space separated list of
  domains to accept tracking data from.}

  \item{keyname}{Your API key name in your .Rprofile file}

  \item{verbose}{Print http status (default) or not}
}
\value{
  Gives HTTP status and metadata for the new gauge.
}
\description{
  Updates and returns a gauge with the updates applied.
}
\details{
  Note that you can create gaguges with the same names,
  beware.
}
\note{
  Note that these examples only work if you provide your
  Gaug.es API key either by passing in the function, or
  storing your key in your .Rprofile file, defaults to
  looking for an entry of "GaugesKey".
}
\examples{
\dontrun{
out <- gs_gauge_create(title='foo_bar')
gs_gauge_update(id=out$id, tz=out$tz, title='dumb')
}
}

