/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.tree;

import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.AlphaDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.SimpleDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropArborescences
extends Propagator<DirectedGraphVar> {
    protected DirectedGraphVar g;
    protected DirectedGraph connectedGraph;
    protected int n;
    protected AbstractLengauerTarjanDominatorsFinder domFinder;
    protected ISet[] successors;
    protected BitSet mandVert;

    public PropArborescences(DirectedGraphVar graph) {
        this(graph, false);
    }

    public PropArborescences(DirectedGraphVar graph, boolean simple) {
        super((Variable[])new DirectedGraphVar[]{graph}, (Priority)PropagatorPriority.QUADRATIC, false);
        this.g = graph;
        this.n = this.g.getNbMaxNodes();
        this.successors = new ISet[this.n];
        this.connectedGraph = new DirectedGraph(this.n + 1, SetType.BITSET, true);
        this.mandVert = new BitSet(this.n);
        this.domFinder = simple ? new SimpleDominatorsFinder(this.n, this.connectedGraph) : new AlphaDominatorsFinder(this.n, this.connectedGraph);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.reset();
        if (this.domFinder.findDominators()) {
            this.remBackArcs();
            this.enforceDominators();
        } else {
            this.fails();
        }
    }

    protected void reset() {
        for (int i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccessorsOf(i).clear();
            this.connectedGraph.getPredecessorsOf(i).clear();
        }
        for (int i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.g.getPotentialPredecessorOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int y = (Integer)iSetIterator.next();
                this.connectedGraph.addEdge(y, i);
            }
            ISet nei = this.g.getMandatoryPredecessorsOf(i);
            if (!nei.isEmpty()) continue;
            this.connectedGraph.addEdge(this.n, i);
        }
    }

    protected void remBackArcs() throws ContradictionException {
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int x = (Integer)iSetIterator.next();
            this.g.removeEdge(x, x, this);
            ISetIterator iSetIterator2 = this.g.getPotentialSuccessorsOf(x).iterator();
            while (iSetIterator2.hasNext()) {
                int y = (Integer)iSetIterator2.next();
                if (!this.domFinder.isDomminatedBy(x, y)) continue;
                this.g.removeEdge(x, y, this);
            }
        }
    }

    protected void enforceDominators() throws ContradictionException {
        this.mandVert.clear();
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int x = (Integer)iSetIterator.next();
            this.mandVert.set(x);
        }
        while (this.mandVert.nextSetBit(0) >= 0) {
            this.enforceDominatorsFrom(this.mandVert.nextSetBit(0));
        }
    }

    protected void enforceDominatorsFrom(int j) throws ContradictionException {
        this.mandVert.clear(j);
        int i = this.domFinder.getImmediateDominatorsOf(j);
        if (i != this.n) {
            ISet pred;
            if (!this.domFinder.isDomminatedBy(j, i)) {
                throw new UnsupportedOperationException();
            }
            if (this.g.enforceNode(i, this)) {
                this.mandVert.set(i);
            }
            if ((pred = this.g.getPotentialPredecessorOf(j)).contains(i) && !this.g.getMandatoryPredecessorsOf(j).contains(i)) {
                boolean arcDom = true;
                ISetIterator iSetIterator = pred.iterator();
                while (iSetIterator.hasNext()) {
                    int p = (Integer)iSetIterator.next();
                    if (p == i || this.domFinder.isDomminatedBy(p, j)) continue;
                    arcDom = false;
                }
                if (arcDom) {
                    this.g.enforceEdge(i, j, this);
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        StrongConnectivityFinder scfinder = new StrongConnectivityFinder((DirectedGraph)this.g.getLB());
        scfinder.findAllSCC();
        if (this.g.getMandatoryNodes().size() - scfinder.getNbSCC() > 0) {
            return ESat.FALSE;
        }
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.g.getMandatoryPredecessorsOf(i).size() <= 1) continue;
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

