% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_counts.R
\name{compare_counts}
\alias{compare_counts}
\title{Compare counts}
\usage{
compare_counts(
  df,
  interval = c("year", "month")[1],
  what = c("crashes", "fatalities", "injuries", "people")[1],
  where = list(states = "all", region = c("all", "ne", "mw", "s", "w")[1], urb = c("all",
    "rural", "urban")[1]),
  who = c("all", "drivers", "passengers", "bicyclists", "pedestrians")[1],
  involved = NULL,
  what2 = what,
  where2 = where,
  who2 = who,
  involved2 = involved
)
}
\arguments{
\item{df}{The input FARS object.}

\item{interval}{The interval in which to count: months or years.}

\item{what}{What to count: crashes, fatalities, or people involved.}

\item{where}{Where to count, a list with up to three elements:
states ("all" by default), region ("all"), urb ("all")}

\item{who}{The type of person to count: all (default) drivers, passengers,
pedestrians, or bicyclists.}

\item{involved}{Factors involved with the crash. Can be any of: distracted
driver, police pursuit, motorcycle, pedalcyclist,
bicyclist, pedestrian, pedbike, young driver, older driver, speeding,
alcohol, drugs, hit and run, roadway departure, rollover, or large
trucks.}

\item{what2}{Comparison point for 'what' (set to 'what' unless specified).}

\item{where2}{Comparison point for 'where' (set to 'where' unless specified).}

\item{who2}{Comparison point for 'who' (set to 'who' unless specified).}

\item{involved2}{Comparison point for 'involved' (set to 'involved' unless specified).}
}
\value{
A tibble of counts.
}
\description{
Compare counts generated by counts()
}
\examples{

  \dontrun{
    compare_counts(
      get_fars(years = 2020, states="Virginia"),
      where = list(urb="rural"),
      where2 = list(urb="urban")
      )
   }
}
