% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_facts.R
\name{get_facts_engine}
\alias{get_facts_engine}
\title{Get the FACTS engine function matching your FACTS file}
\usage{
get_facts_engine(facts_file)
}
\arguments{
\item{facts_file}{Character, name of a FACTS file.
Usually has a \verb{*.facts} file extension.}
}
\value{
Character, the name of a FACTS engine function.
}
\description{
Identify the correct \verb{run_engine_*()} function
for your FACTS file.
}
\details{
For most cases, it is sufficient to call \code{\link[=run_facts]{run_facts()}},
or to call \code{\link[=run_flfll]{run_flfll()}} followed by \code{\link[=run_engine]{run_engine()}}. But either way,
you will need to know the arguments of the \verb{run_engine_*()} function
that corresponds to your FACTS file. Even if you are not calling this
\verb{run_engine_*()} directly, you will need to pass the arguments to \code{...}
in \code{\link[=run_facts]{run_facts()}} or \code{\link[=run_engine]{run_engine()}}. \code{get_facts_engine()}
identifies the correct \verb{run_engine_*()} function so you can open the
help file and read about the arguments, e.g. \code{?run_engine_contin}.
}
\examples{
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
facts_file <- get_facts_file_example("contin.facts")
out <- run_flfll(facts_file, verbose = FALSE) # Generate param files.
# Find the appropriate FACTS engine function.
get_facts_engine(facts_file)
# Read about the function arguments.
# You can pass these arguments to `...` in `run_facts()`
# or `run_engine()` or just call `run_engine_contin()` directly.
# ?run_engine_contin
# Call the FACTS engine function to run simulations.
# Alternatively, you could just call `run_engine()`.
run_engine_contin(out, n_sims = 1, verbose = FALSE, version = "6.2.5")
# See the results.
read_patients(out)
}
}
\seealso{
\code{\link[=run_facts]{run_facts()}}, \code{\link[=run_engine]{run_engine()}}
}
