% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.randomForest}
\alias{summary.rfPermute}
\title{Diagnostics of \code{rfPermute} or \code{randomForest} models.}
\usage{
\method{summary}{randomForest}(object, ...)

\method{summary}{rfPermute}(object, ...)
}
\arguments{
\item{object}{a \code{rfPermute} or \code{randomForest} model object to 
summarize.}

\item{...}{arguments passed to \code{\link{plotInbag}}.}
}
\value{
A combination of plots from \code{\link{plotTrace}} and 
  \code{\link{plotInbag}} as well as summary confusion matrices 
  (classification) or error rates (regression) from the model.
}
\description{
Combine plots of error traces and inbag rates.
}
\examples{
# A regression model using the ozone example
data(airquality)
ozone.rp <- rfPermute(
  Ozone ~ ., data = airquality, na.action = na.omit,
  ntree = 100, nrep = 50, num.cores = 1
)

summary(ozone.rp)
 
}
\seealso{
\code{\link{plotTrace}}, \code{\link{plotInbag}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
