% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_retrosheet.R
\name{get_retrosheet}
\alias{get_retrosheet}
\title{Import single-season retrosheet data as data frames}
\usage{
get_retrosheet(...)
}
\arguments{
\item{...}{Arguments passed to `getRetrosheet()`. `stringsAsFactors` argument is always FALSE, and will warn if passed as TRUE}
}
\value{
The following return values are possible for the given \code{type}
\itemize{
\item \code{game} - a data frame of gamelog data for the given year
\item \code{play} - a list, each element of which is a single game's play-by-play
data for the given team and year.  Each list element is also a list, containing
the play-by-play data split into individual matrices.
\item \code{roster} - a named list, each element containing the roster
for the named team for the given year, as a data frame.
\item \code{schedule} - a data frame containing the game schedule for the given year
}
}
\description{
This function is a wrapper for getRetrosheet(). It downloads and parses data from
\url{http://www.retrosheet.org} for the game-log, event, (play-by-play), roster, and schedule files.
While getRetrosheet() returns a list of matrices, this function returns an equivalent list of dataframes.
It takes the same arguments, and can act as a drop-in replacement.
}
\examples{
\donttest{
## get the full 1995 season schedule
get_retrosheet("schedule", 1995)

## get the same schedule, split by time of day
get_retrosheet("schedule", 1995, schedSplit = "TimeOfDay")

## get the roster data for the 1995 season, listed by team
get_retrosheet("roster", 1995)

## get the full gamelog data for the 2012 season
get_retrosheet("game", 2012)

## get the play-by-play data for the San Francisco Giants' 2012 season
get_retrosheet("play", 2012, "SFN")
}

}
