% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principalSturmHabicht.R
\name{principalSturmHabicht}
\alias{principalSturmHabicht}
\title{Principal Sturm-Habicht sequence of a polynomial}
\usage{
principalSturmHabicht(qspray, var = 1)
}
\arguments{
\item{qspray}{a \code{qspray} polynomial with at most nine variables}

\item{var}{integer indicating with respect to which variable the resultant
is desired (e.g. \code{1} for \code{x} and \code{2} for \code{y})}
}
\value{
For a univariate polynomial, this returns a vector of \code{bigq}
  rational numbers.
  For a multivariate polynomial, this returns a list of \code{qspray}
  polynomials that do not involve the \code{var}-th variable.
}
\description{
Principal Sturm-Habicht sequence of a polynomial with rational
  coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
qspray <- x^3*y^2 - 5*x*y^2 + 7*x - 2
principalSturmHabicht(qspray, var = 1)
principalSturmHabicht(qspray, var = 2)
}
