/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.stack.array.TIntArrayStack;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

@Explained
public class PropAllDiffInst
extends Propagator<IntVar> {
    protected final int n;
    protected FastResetArrayStack toCheck = new FastResetArrayStack();

    public PropAllDiffInst(IntVar[] variables) {
        super((Variable[])variables, (Priority)PropagatorPriority.UNARY, true);
        this.n = ((IntVar[])this.vars).length;
        if (this.lcg()) {
            IntIterableRangeSet set = new IntIterableRangeSet();
            for (IntVar var : (IntVar[])this.vars) {
                set.addAll(var);
            }
            if (set.size() == ((IntVar[])this.vars).length) {
                TIntArrayList ps = new TIntArrayList();
                ISetIterator iSetIterator = set.iterator();
                while (iSetIterator.hasNext()) {
                    int v = (Integer)iSetIterator.next();
                    for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                        ps.add(((IntVar[])this.vars)[i].getLit(v, 1));
                    }
                    this.getModel().getSolver().getSat().addClause(ps);
                    ps.clear();
                }
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.toCheck.resetQuick();
        for (int v = 0; v < this.n; ++v) {
            if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
            this.toCheck.push(v);
        }
        this.fixpoint();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.toCheck.resetQuick();
        this.toCheck.push(varIdx);
        this.fixpoint();
    }

    protected void fixpoint() throws ContradictionException {
        while (this.toCheck.size() > 0) {
            int vidx = this.toCheck.pop();
            int val = ((IntVar[])this.vars)[vidx].getValue();
            for (int i = 0; i < this.n; ++i) {
                if (i == vidx) continue;
                if (!this.lcg()) {
                    if (!((IntVar[])this.vars)[i].removeValue(val, (ICause)this) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                    this.toCheck.push(i);
                    continue;
                }
                if (((IntVar[])this.vars)[i].isInstantiatedTo(val)) {
                    this.fails(this.explain(i, vidx));
                }
                if (!((IntVar[])this.vars)[i].removeValue(val, this, this.explain(vidx, -1)) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                this.toCheck.push(i);
            }
        }
    }

    private Reason explain(int i, int j) {
        return Reason.r(((IntVar[])this.vars)[i].getValLit(), j > -1 ? ((IntVar[])this.vars)[j].getValLit() : 0);
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            for (int j = i + 1; j < this.n; ++j) {
                if (!((IntVar[])this.vars)[j].isInstantiatedTo(((IntVar[])this.vars)[i].getValue())) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    protected static class FastResetArrayStack
    extends TIntArrayStack {
        protected FastResetArrayStack() {
        }

        void resetQuick() {
            this._list.resetQuick();
        }
    }
}

