/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.trees.lagrangian;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import org.chocosolver.solver.constraints.graph.cost.GraphLagrangianRelaxation;
import org.chocosolver.solver.constraints.graph.cost.trees.lagrangian.AbstractTreeFinder;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.graphOperations.LCAGraphManager;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;

public class KruskalMSTGAC
extends AbstractTreeFinder {
    private TIntArrayList ma;
    private final int[] sortedArcs;
    private final BitSet activeArcs;
    private final double[] costs;
    private final int[] p;
    private final int[] rank;
    private final int ccN;
    private final DirectedGraph ccTree;
    private final int[] ccTp;
    private final double[] ccTEdgeCost;
    private final LCAGraphManager lca;
    private int cctRoot;
    private final BitSet useful;
    private double maxTArc;
    private final int[][] map;
    private final double[][] repCosts;
    private final int[] fifo;
    private final ArraySort<?> sorter;
    private final IntComparator comparator;

    public KruskalMSTGAC(int nbNodes, GraphLagrangianRelaxation propagator) {
        super(nbNodes, propagator);
        this.activeArcs = new BitSet(this.n * this.n);
        this.rank = new int[this.n];
        this.costs = new double[this.n * this.n];
        this.sortedArcs = new int[this.n * this.n];
        this.p = new int[this.n];
        this.ccN = 2 * this.n + 1;
        this.ccTree = new DirectedGraph(this.ccN, SetType.LINKED_LIST, false);
        this.ccTEdgeCost = new double[this.ccN];
        this.ccTp = new int[this.n];
        this.useful = new BitSet(this.n);
        this.lca = new LCAGraphManager(this.ccN);
        this.map = new int[this.n][this.n];
        this.repCosts = new double[this.n][this.n];
        this.fifo = new int[this.n];
        this.sorter = new ArraySort(this.n * this.n, false, true);
        this.comparator = (i1, i2) -> Double.compare(this.costs[i1], this.costs[i2]);
    }

    private void sortArcs(double[][] costMatrix) {
        int i;
        int size = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.p[i2] = i2;
            this.rank[i2] = 0;
            this.ccTp[i2] = i2;
            this.Tree.getNeighborsOf(i2).clear();
            this.ccTree.removeNode(i2);
            this.ccTree.addNode(i2);
            size += this.g.getNeighborsOf(i2).size();
        }
        size /= 2;
        int idx = 0;
        for (i = 0; i < this.n; ++i) {
            ISet nei = this.g.getNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                assert (i != j);
                if (i >= j) continue;
                this.sortedArcs[idx] = i * this.n + j;
                this.costs[i * this.n + j] = costMatrix[i][j];
                ++idx;
            }
        }
        assert (idx == size);
        for (i = this.n; i < this.ccN; ++i) {
            this.ccTree.removeNode(i);
        }
        this.sorter.sort(this.sortedArcs, size, this.comparator);
        this.activeArcs.clear();
        this.activeArcs.set(0, size);
    }

    @Override
    public void computeMST(double[][] costs, UndirectedGraph graph) throws ContradictionException {
        this.g = graph;
        this.ma = this.propHK.getMandatoryArcsList();
        this.sortArcs(costs);
        this.treeCost = 0.0;
        this.cctRoot = this.n - 1;
        int tSize = this.addMandatoryArcs();
        this.connectMST(tSize);
    }

    @Override
    public void performPruning(double UB) throws ContradictionException {
        double delta = UB - this.treeCost;
        assert (delta >= 0.0);
        this.prepareMandArcDetection();
        if (this.selectRelevantArcs(delta)) {
            this.lca.preprocess(this.cctRoot, this.ccTree);
            this.pruning(delta);
        }
    }

    private void prepareMandArcDetection() {
        int first;
        for (int i = 0; i < this.n; ++i) {
            this.ccTp[i] = -1;
        }
        this.useful.clear();
        this.useful.set(0);
        this.ccTp[0] = 0;
        int last = first = 0;
        int k = 0;
        this.fifo[last++] = k;
        while (first < last) {
            k = this.fifo[first++];
            ISet nei = this.Tree.getNeighborsOf(k);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int s = (Integer)iSetIterator.next();
                if (this.ccTp[s] != -1) continue;
                this.ccTp[s] = k;
                this.map[s][k] = -1;
                this.map[k][s] = -1;
                if (this.useful.get(s)) continue;
                this.fifo[last++] = s;
                this.useful.set(s);
            }
        }
    }

    private void markTreeEdges(int[] next, int i, int j) {
        int tmp;
        int rep = i * this.n + j;
        if (this.Tree.containsEdge(j, i)) {
            if (this.map[j][i] == -1) {
                int n = rep;
                this.map[i][j] = n;
                this.map[j][i] = n;
            }
            return;
        }
        if (next[i] == next[j]) {
            if (this.map[i][next[i]] == -1) {
                int n = rep;
                this.map[next[i]][i] = n;
                this.map[i][next[i]] = n;
            }
            if (this.map[j][next[j]] == -1) {
                int n = rep;
                this.map[next[j]][j] = n;
                this.map[j][next[j]] = n;
            }
            return;
        }
        this.useful.clear();
        int meeting = j;
        int a = i;
        while (a != next[a]) {
            this.useful.set(a);
            a = next[a];
        }
        this.useful.set(a);
        while (!this.useful.get(meeting)) {
            meeting = next[meeting];
        }
        int b = j;
        while (b != meeting) {
            tmp = next[b];
            next[b] = meeting;
            if (this.map[b][tmp] == -1) {
                int n = rep;
                this.map[tmp][b] = n;
                this.map[b][tmp] = n;
            }
            b = tmp;
        }
        a = i;
        while (a != meeting) {
            tmp = next[a];
            next[a] = meeting;
            if (this.map[a][tmp] == -1) {
                int n = rep;
                this.map[tmp][a] = n;
                this.map[a][tmp] = n;
            }
            a = tmp;
        }
    }

    private boolean selectRelevantArcs(double delta) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        while (idx >= 0 && this.costs[this.sortedArcs[idx]] - this.maxTArc <= delta) {
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        while (idx >= 0) {
            if (!this.Tree.containsEdge(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n)) {
                this.propHK.remove(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n);
                this.activeArcs.clear(idx);
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        ++this.cctRoot;
        int newNode = this.cctRoot;
        this.ccTree.addNode(newNode);
        this.ccTEdgeCost[newNode] = this.propHK.getMinArcVal();
        ISetIterator iSetIterator = this.ccTree.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (i == this.cctRoot || !this.ccTree.getPredecessorsOf(i).isEmpty()) continue;
            this.ccTree.addEdge(this.cctRoot, i);
        }
        return true;
    }

    private void pruning(double delta) throws ContradictionException {
        int i;
        int arc = this.activeArcs.nextSetBit(0);
        while (arc >= 0) {
            i = this.sortedArcs[arc] / this.n;
            int j = this.sortedArcs[arc] % this.n;
            if (!this.Tree.containsEdge(i, j)) {
                this.repCosts[i][j] = this.costs[i * this.n + j] - this.ccTEdgeCost[this.lca.getLCA(i, j)];
                if (this.repCosts[i][j] > delta) {
                    this.activeArcs.clear(arc);
                    this.propHK.remove(i, j);
                } else {
                    this.markTreeEdges(this.ccTp, i, j);
                }
            }
            arc = this.activeArcs.nextSetBit(arc + 1);
        }
        for (i = 0; i < this.n; ++i) {
            ISet nei = this.Tree.getNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                if (this.map[i][j] != -1) {
                    this.repCosts[i][j] = this.costs[this.map[i][j]] - this.costs[i * this.n + j];
                    if (!(this.repCosts[i][j] > delta)) continue;
                    this.propHK.enforce(i, j);
                    continue;
                }
                this.propHK.enforce(i, j);
            }
        }
    }

    private int addMandatoryArcs() throws ContradictionException {
        int tSize = 0;
        double val = this.propHK.getMinArcVal();
        for (int i = this.ma.size() - 1; i >= 0; --i) {
            int rTo;
            int arc = this.ma.get(i);
            int from = arc / this.n;
            int to = arc % this.n;
            int rFrom = this.findUF(from);
            if (rFrom != (rTo = this.findUF(to))) {
                this.linkUF(rFrom, rTo);
                this.Tree.addEdge(from, to);
                this.updateCCTree(rFrom, rTo, val);
                this.treeCost += this.costs[arc];
                ++tSize;
                continue;
            }
            this.propHK.contradiction();
        }
        return tSize;
    }

    private void connectMST(int tSize) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        double minTArc = -this.propHK.getMinArcVal();
        this.maxTArc = this.propHK.getMinArcVal();
        while (tSize < this.n - 1) {
            int rTo;
            if (idx < 0) {
                this.propHK.contradiction();
            }
            int from = this.sortedArcs[idx] / this.n;
            int to = this.sortedArcs[idx] % this.n;
            int rFrom = this.findUF(from);
            if (rFrom != (rTo = this.findUF(to))) {
                this.linkUF(rFrom, rTo);
                this.Tree.addEdge(from, to);
                double cost = this.costs[this.sortedArcs[idx]];
                this.updateCCTree(rFrom, rTo, cost);
                if (cost > this.maxTArc) {
                    this.maxTArc = cost;
                }
                if (cost < minTArc) {
                    minTArc = cost;
                }
                this.treeCost += cost;
                ++tSize;
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
    }

    private void updateCCTree(int rfrom, int rto, double cost) {
        ++this.cctRoot;
        int newNode = this.cctRoot;
        this.ccTree.addNode(newNode);
        this.ccTree.addEdge(newNode, this.ccTp[rfrom]);
        this.ccTree.addEdge(newNode, this.ccTp[rto]);
        this.ccTp[rfrom] = newNode;
        this.ccTp[rto] = newNode;
        this.ccTEdgeCost[newNode] = cost;
    }

    private void linkUF(int x, int y) {
        if (this.rank[x] > this.rank[y]) {
            this.p[y] = this.p[x];
        } else {
            this.p[x] = this.p[y];
        }
        if (this.rank[x] == this.rank[y]) {
            int n = y;
            this.rank[n] = this.rank[n] + 1;
        }
    }

    private int findUF(int i) {
        if (this.p[i] != i) {
            this.p[i] = this.findUF(this.p[i]);
        }
        return this.p[i];
    }

    @Override
    public double getRepCost(int from, int to) {
        return this.repCosts[from][to];
    }
}

