/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.chocosolver.sat.Literalizer;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.SatDecorator;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.hybrid.HybridTuples;
import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.constraints.nary.cnf.LogicTreeToolBox;
import org.chocosolver.solver.constraints.nary.sat.PropSat;
import org.chocosolver.solver.constraints.reification.LocalConstructiveDisjunction;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public interface ISatFactory
extends ISelf<Model> {
    default public int satVar(Variable var, Literalizer ltz) {
        PropSat psat = ((Model)this.ref()).getMinisat().getPropSat();
        SatDecorator msat = (SatDecorator)psat.getMiniSat();
        return msat.bind(var, ltz, psat::lazyAddVar);
    }

    default public MiniSat sat() {
        if (((Model)this.ref()).getSolver().isLCG()) {
            return ((Model)this.ref()).getSolver().getSat();
        }
        PropSat psat = ((Model)this.ref()).getMinisat().getPropSat();
        return psat.getMiniSat();
    }

    default public int lit(int svar) {
        return MiniSat.makeLiteral(svar, true);
    }

    default public int neg(int svar) {
        return MiniSat.makeLiteral(svar, false);
    }

    default public boolean addClause(int ... lits) {
        TIntArrayList mlits = new TIntArrayList(lits);
        return this.sat().addClause(mlits);
    }

    default public boolean addClauses(LogOp TREE) {
        ILogical tree = LogicTreeToolBox.toCNF(TREE, (Model)this.ref());
        boolean ret = true;
        if (((Model)this.ref()).boolVar(true).equals(tree)) {
            ret = this.addClauseTrue(((Model)this.ref()).boolVar(true));
        } else if (((Model)this.ref()).boolVar(false).equals(tree)) {
            ret = this.addClauseTrue(((Model)this.ref()).boolVar(false));
        } else {
            ILogical[] clauses = !tree.isLit() && ((LogOp)tree).is(LogOp.Operator.AND) ? ((LogOp)tree).getChildren() : new ILogical[]{tree};
            for (int i = 0; i < clauses.length; ++i) {
                ILogical clause = clauses[i];
                if (clause.isLit()) {
                    BoolVar bv = (BoolVar)clause;
                    ret &= this.addClauseTrue(bv);
                    continue;
                }
                LogOp n = (LogOp)clause;
                BoolVar[] bvars = n.flattenBoolVar();
                if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
                    TIntArrayList lits = new TIntArrayList(bvars.length);
                    MiniSat sat = this.sat();
                    sat.beforeAddingClauses();
                    for (int j = 0; j < bvars.length; ++j) {
                        lits.add(MiniSat.makeLiteral(bvars[j].satVar(), true));
                    }
                    ret &= sat.addClause(lits);
                    sat.afterAddingClauses();
                    continue;
                }
                ((Model)this.ref()).sum(bvars, ">", 0).post();
            }
        }
        return ret;
    }

    default public boolean addClauses(BoolVar[] POSLITS, BoolVar[] NEGLITS) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] pos = new int[POSLITS.length];
            for (int i = 0; i < POSLITS.length; ++i) {
                pos[i] = POSLITS[i].satVar();
            }
            int[] neg = new int[NEGLITS.length];
            for (int i = 0; i < NEGLITS.length; ++i) {
                neg[i] = NEGLITS[i].satVar();
            }
            boolean add = sat.addClause(pos, neg);
            sat.afterAddingClauses();
            return add;
        }
        int PL = POSLITS.length;
        int NL = NEGLITS.length;
        BoolVar[] LITS = new BoolVar[PL + NL];
        System.arraycopy(POSLITS, 0, LITS, 0, PL);
        for (int i = 0; i < NL; ++i) {
            LITS[i + PL] = NEGLITS[i].not();
        }
        ((Model)this.ref()).sum(LITS, ">", 0).post();
        return true;
    }

    default public boolean addClauseTrue(BoolVar BOOLVAR) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addTrue(BOOLVAR.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)BOOLVAR, "=", 1).post();
        return true;
    }

    default public boolean addClauseFalse(BoolVar BOOLVAR) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addFalse(BOOLVAR.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)BOOLVAR, "=", 0).post();
        return true;
    }

    default public boolean addClausesBoolEq(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolEq(LEFT.satVar(), RIGHT.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolLe(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolLe(LEFT.satVar(), RIGHT.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "<=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolLt(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolLt(LEFT.satVar(), RIGHT.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "<", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolNot(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolNot(LEFT.satVar(), RIGHT.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "!=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolOrArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addBoolOrArrayEqVar(vars, TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).max(TARGET, BOOLVARS).post();
        return true;
    }

    default public boolean addClausesBoolAndArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addBoolAndArrayEqVar(vars, TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).min(TARGET, BOOLVARS).post();
        return true;
    }

    default public boolean addClausesBoolOrEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolOrEqVar(LEFT.satVar(), RIGHT.satVar(), TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "+", (IntVar)RIGHT, ">", 0).reifyWith(TARGET);
        return true;
    }

    default public boolean addClausesBoolAndEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolAndEqVar(LEFT.satVar(), RIGHT.satVar(), TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).arithm((IntVar)LEFT, "+", (IntVar)RIGHT, "=", 2).reifyWith(TARGET);
        return true;
    }

    default public boolean addClausesBoolXorEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        return this.addClausesBoolIsNeqVar(LEFT, RIGHT, TARGET);
    }

    default public boolean addClausesBoolIsEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolIsEqVar(LEFT.satVar(), RIGHT.satVar(), TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXeqY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsNeqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolIsNeqVar(LEFT.satVar(), RIGHT.satVar(), TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXneY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsLeVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolIsLeVar(LEFT.satVar(), RIGHT.satVar(), TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXleY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsLtVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = sat.addBoolIsLtVar(LEFT.satVar(), RIGHT.satVar(), TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).reifyXltY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolOrArrayEqualTrue(BoolVar[] BOOLVARS) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addBoolOrArrayEqualTrue(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, ">", 0).post();
        return true;
    }

    default public boolean addClausesBoolAndArrayEqualFalse(BoolVar[] BOOLVARS) {
        return this.addClausesAtMostNMinusOne(BOOLVARS);
    }

    default public boolean addClausesAtMostOne(BoolVar[] BOOLVARS) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addAtMostOne(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, "<", 2).post();
        return true;
    }

    default public boolean addClausesAtMostNMinusOne(BoolVar[] BOOLVARS) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addAtMostNMinusOne(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, "<", BOOLVARS.length).post();
        return true;
    }

    default public boolean addClausesSumBoolArrayGreaterEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addSumBoolArrayGreaterEqVar(vars, TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this.ref()).sum(BOOLVARS, ">=", (IntVar)TARGET).post();
        return true;
    }

    default public boolean addClausesMaxBoolArrayLessEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            boolean add = sat.addMaxBoolArrayLessEqVar(vars, TARGET.satVar());
            sat.afterAddingClauses();
            return add;
        }
        BoolVar max = ((Model)this.ref()).boolVar(((Model)this.ref()).generateName("bool_max"));
        ((Model)this.ref()).max(max, BOOLVARS).post();
        max.le(TARGET).post();
        return true;
    }

    default public boolean addClausesSumBoolArrayLessEqKVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT()) {
            MiniSat sat = this.sat();
            sat.beforeAddingClauses();
            boolean add = false;
            if (BOOLVARS.length == 1) {
                add = this.addClausesBoolLe(BOOLVARS[0], TARGET);
            }
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = BOOLVARS[i].satVar();
            }
            sat.afterAddingClauses();
            return add |= sat.addSumBoolArrayLessEqKVar(vars, TARGET.satVar());
        }
        int[] coeffs = new int[BOOLVARS.length + 1];
        Arrays.fill(coeffs, 1);
        coeffs[BOOLVARS.length] = -BOOLVARS.length;
        IntVar[] nBOOLVARS = new BoolVar[BOOLVARS.length + 1];
        System.arraycopy(BOOLVARS, 0, nBOOLVARS, 0, BOOLVARS.length);
        nBOOLVARS[BOOLVARS.length] = TARGET;
        ((Model)this.ref()).scalar(nBOOLVARS, coeffs, "<=", 0).post();
        return true;
    }

    default public boolean addConstructiveDisjunction(Constraint ... cstrs) {
        new LocalConstructiveDisjunction(cstrs).post();
        return true;
    }

    default public boolean addElement(IntVar VALUE, int[] TABLE, IntVar INDEX, int OFFSET) {
        if (!(1.$assertionsDisabled || ((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT())) {
            throw new AssertionError();
        }
        Tuples t = new Tuples(true);
        for (int i = 0; i < TABLE.length; ++i) {
            t.add(i, TABLE[i]);
        }
        this.addTable(new IntVar[]{((Model)this.ref()).intView(1, INDEX, -OFFSET), VALUE}, t);
        return true;
    }

    default public boolean addTable(IntVar[] vars, Tuples tuples) {
        if (!1.$assertionsDisabled && vars.length < 2) {
            throw new AssertionError();
        }
        if (!(1.$assertionsDisabled || ((Model)this.ref()).getSolver().isLCG() || ((Model)this.ref()).getSettings().enableSAT())) {
            throw new AssertionError();
        }
        MiniSat sat = this.sat();
        sat.beforeAddingClauses();
        if (!tuples.isFeasible()) {
            TIntArrayList c = new TIntArrayList();
            for (int i = 0; i < tuples.nbTuples(); ++i) {
                int[] t = tuples.get(i);
                c.clear();
                for (int j = 0; j < vars.length; ++j) {
                    c.add(vars[j].getLit(t[j], 0));
                }
                sat.addClause(c);
            }
            sat.afterAddingClauses();
            return true;
        }
        int star = tuples.allowUniversalValue() ? tuples.getStarValue() : Integer.MAX_VALUE;
        int base_lit = 2 * sat.nVars();
        if (vars.length > 2) {
            for (int i = 0; i < tuples.nbTuples(); ++i) {
                int[] t = tuples.get(i);
                sat.newVariable();
                for (int j = 0; j < vars.length; ++j) {
                    if (t[j] == star) continue;
                    sat.addClause(base_lit + 2 * i, vars[j].getLit(t[j], 1));
                }
            }
        }
        for (int w = 0; w < vars.length; ++w) {
            int lb = vars[w].getLB();
            TIntList[] sup = new TIntList[vars[w].getRange()];
            int i = lb;
            while (i <= vars[w].getUB()) {
                sup[i - lb] = new TIntArrayList();
                i = vars[w].nextValue(i);
            }
            for (i = 0; i < tuples.nbTuples(); ++i) {
                int[] t = tuples.get(i);
                int p = vars.length == 2 ? (t[1 - w] == star ? 1 : vars[1 - w].getLit(t[1 - w], 1)) : base_lit + 2 * i + 1;
                int k = t[w] - lb;
                if (k >= 0 && k < sup.length && sup[k] != null) {
                    sup[k].add(p);
                    continue;
                }
                if (t[w] != star) continue;
                for (TIntList l : sup) {
                    if (l == null) continue;
                    l.add(p);
                }
            }
            for (i = 0; i < sup.length; ++i) {
                if (sup[i] == null) continue;
                if (sup[i].isEmpty()) {
                    sat.addClause(vars[w].getLit(i + lb, 0));
                    continue;
                }
                sup[i].add(vars[w].getLit(i + lb, 0));
                int p = sup[i].get(0);
                int last = sup[i].size() - 1;
                sup[i].set(0, sup[i].get(last));
                sup[i].set(last, p);
                sat.addClause(sup[i]);
            }
        }
        sat.afterAddingClauses();
        return true;
    }

    default public boolean addTable(IntVar[] vars, HybridTuples tuples) {
        throw new UnsupportedOperationException();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

