/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.clauses;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.stream.Stream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.clauses.PropSignedClause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.learn.XParameters;
import org.chocosolver.solver.search.strategy.selectors.variables.ClausesBased;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.ShrinkableList;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.tree.Interval;
import org.chocosolver.util.objects.tree.IntervalTree;
import org.chocosolver.util.tools.ArrayUtils;

public class ClauseStore
extends Propagator<IntVar> {
    private static int SID = 1;
    private final Solver mSolver;
    private final List<SignedClause> clauses;
    private final List<SignedClause> learnts;
    private final int nbMaxLearnts;
    private final double ratio;
    private final int domPerimeter;
    private SignedClause last;
    private final HashMap<IntVar, IntervalTree<Container>> watches;
    private double clauseInc = 1.0;
    private ClausesBased strat;

    ClauseStore(Model mModel) {
        super((Variable[])new IntVar[]{mModel.intVar(0)}, (Priority)PropagatorPriority.LINEAR, true, false);
        this.vars = new IntVar[0];
        this.mSolver = mModel.getSolver();
        this.nbMaxLearnts = this.model.getSettings().getNbMaxLearntClauses();
        this.ratio = this.model.getSettings().getRatioForClauseStoreReduction();
        this.domPerimeter = this.model.getSettings().getLearntClausesDominancePerimeter();
        this.clauses = new ArrayList<SignedClause>();
        this.learnts = new ArrayList<SignedClause>();
        this.last = null;
        this.watches = new HashMap();
        this.setActive0();
    }

    public int getNbClauses() {
        return this.clauses.size();
    }

    public int getNbLearntClauses() {
        return this.learnts.size();
    }

    public void declareClausesBasedStrategy(ClausesBased strat) {
        this.strat = strat;
    }

    public void add(IntVar[] vars, IntIterableRangeSet[] ranges) {
        if (XParameters.INTERVAL_TREE) {
            SignedClause cl = new SignedClause(vars, ranges);
            this.attach(new Watcher(cl.pos[0], cl));
            this.attach(new Watcher(cl.pos[1], cl));
            if (this.model.getSolver().getEngine().isInitialized()) {
                this.learnts.add(cl);
                this.last = cl;
                this.last.activity = this.clauseInc;
                this.last.rawActivity = 1;
                if (XParameters.PRINT_CLAUSE) {
                    this.model.getSolver().log().white().printf("learn: %s\n", cl);
                }
            } else {
                if (XParameters.PRINT_CLAUSE) {
                    this.model.getSolver().log().white().printf("add: %s\n", cl);
                }
                this.clauses.add(cl);
            }
            this.mSolver.getEngine().dynamicAddition(true, cl);
        } else {
            PropSignedClause cl = PropSignedClause.makeFromIn(vars, ranges);
            if (XParameters.PRINT_CLAUSE) {
                this.model.getSolver().log().white().printf("learn: %s\n", cl);
            }
            new Constraint("SC", cl).post();
        }
    }

    private void attach(Watcher w) {
        Container ct;
        IntVar var = w.c.v(w.p);
        IntervalTree<Container> wm = this.watches.get(var);
        if (wm == null) {
            wm = new IntervalTree();
            this.watches.put(var, wm);
            this.addVariable(new IntVar[]{var});
        }
        if ((ct = wm.get(w.c.l(w.p), w.c.u(w.p))) == null) {
            ct = new Container(w.c.l(w.p), w.c.u(w.p));
            wm.insert(ct);
        }
        ct.add(w);
    }

    private void remove(int idx) {
        SignedClause ng = this.learnts.remove(idx);
        this.mSolver.getEngine().dynamicDeletion(ng);
        ((SignedClause)ng).pos[1] = -1;
        ((SignedClause)ng).pos[0] = -1;
    }

    private void check(SignedClause ng) {
        if (this.mSolver.getDecisionPath().size() > 1) {
            IntVar uni = null;
            int usl = 0;
            int fsl = 0;
            block5: for (int i = 0; i < ng.pos.length; ++i) {
                switch (ng.check(i)) {
                    case TRUE: {
                        throw new SolverException("Learn a satisfied signed clause: " + ng);
                    }
                    case FALSE: {
                        ++fsl;
                        continue block5;
                    }
                    case UNDEFINED: {
                        if (usl == 0 && uni == null) {
                            uni = ng.mvars[i];
                            ++usl;
                            continue block5;
                        }
                        if (usl <= 0 || uni == ng.mvars[i]) continue block5;
                        uni = null;
                    }
                }
            }
            if (fsl < ng.cardinality() - 1 && uni == null) {
                throw new SolverException("Learn a weak clause (" + fsl + "/" + ng.cardinality() + ")");
            }
            if (XParameters.ASSERT_ASSERTING_LEVEL && fsl == ng.cardinality()) {
                throw new SolverException("wrong clause asserting level");
            }
        }
    }

    public void forget() {
        if (this.strat != null) {
            this.strat.decayActivity();
        }
        this.decayActivity();
        if (this.mSolver.getDecisionPath().size() == 1) {
            this.simplifyDB();
        } else if (this.last != null) {
            if (XParameters.ASSERT_UNIT_PROP) {
                this.check(this.last);
            }
            this.detectDominance();
            if (this.strat != null) {
                Stream.of((IntVar[])this.last.getVars()).forEach(v -> this.strat.bump((IntVar)v));
            }
        }
        this.reduceDB();
        this.last = null;
    }

    private void decayActivity() {
        this.clauseInc *= 1.001;
        if (this.clauseInc > 1.0E20) {
            this.clauseInc *= 1.0E-20;
            for (int i = 0; i < this.learnts.size(); ++i) {
                this.learnts.get(i).activity *= 1.0E-20;
            }
        }
    }

    private void simplifyDB() {
        int size = this.learnts.size();
        for (int i = size - 1; i >= 0; --i) {
            SignedClause ng = this.learnts.get(i);
            if (!ng.isNotLocked() || ng.isEntailed() != ESat.TRUE) continue;
            this.remove(i);
        }
        if (size > this.learnts.size() && this.model.getSettings().warnUser()) {
            this.model.getSolver().log().white().printf("Simplify DB: %d -> %d%n", size, this.learnts.size());
        }
    }

    private void reduceDB() {
        int size = this.learnts.size();
        if (size >= this.nbMaxLearnts) {
            this.learnts.sort(Comparator.comparingDouble(c -> -((SignedClause)c).activity));
            long to = Math.round(this.ratio * (double)size);
            int i = size - 1;
            while ((long)i >= to) {
                SignedClause ng = this.learnts.get(i);
                if (ng.isNotLocked() && ng != this.last) {
                    this.remove(i);
                }
                --i;
            }
            if (size > this.learnts.size() && this.model.getSettings().warnUser()) {
                this.model.getSolver().log().white().printf("Reduce DB: %d -> %d%n", size, this.learnts.size());
            }
            for (IntervalTree<Container> t : this.watches.values()) {
                Stack<Container> del = new Stack<Container>();
                for (Container c2 : t) {
                    c2.watchers.removeIf(w -> !w.c.isConnected());
                    if (!c2.watchers.isEmpty()) continue;
                    del.push(c2);
                }
                while (!del.isEmpty()) {
                    t.delete((Container)del.pop());
                }
            }
        }
    }

    private void detectDominance() {
        int size = this.learnts.size();
        SignedClause ng0 = this.learnts.get(size - 1);
        for (int i = size - 2; i >= Math.max(0, size - this.domPerimeter - 1); --i) {
            SignedClause ng = this.learnts.get(i);
            if (!ng.isNotLocked() || ng0.dominate(ng) <= 0) continue;
            this.remove(i);
        }
        if (size > this.learnts.size() && this.model.getSettings().warnUser()) {
            this.model.getSolver().log().white().printf("Dominance DB: %d -> %d%n", size, this.learnts.size());
        }
    }

    public void printStatistics() {
        this.learnts.sort(Comparator.comparingInt(c -> -((SignedClause)c).rawActivity));
        this.model.getSolver().log().white().print("Top ten clauses:\n");
        for (int i = 0; i < 10 && i < this.learnts.size(); ++i) {
            this.model.getSolver().log().white().printf("%d : %d %s\n", i, this.learnts.get(i).rawActivity, this.learnts.get(i));
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        IntVar var = ((IntVar[])this.vars)[idxVarInProp];
        IntervalTree<Container> wm = this.watches.get(var);
        int lb = var.getLB();
        int ub = var.getUB();
        if (IntEventType.isInstantiate(mask) || IntEventType.isRemove(mask)) {
            this.sweep(wm.iterator(), var, lb, ub);
        } else {
            if (IntEventType.isInclow(mask)) {
                wm.forAllBelow(lb, c -> this.checkCont((Container)c, var, lb, ub));
            }
            if (IntEventType.isDecupp(mask)) {
                wm.forAllAbove(ub, c -> this.checkCont((Container)c, var, lb, ub));
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        ESat sat = ESat.TRUE;
        for (i = 0; i < this.clauses.size() && sat == ESat.TRUE; ++i) {
            sat = this.clauses.get(i).isEntailed();
        }
        for (i = 0; i < this.learnts.size() && sat == ESat.TRUE; ++i) {
            sat = this.learnts.get(i).isEntailed();
        }
        return sat;
    }

    private void sweep(Iterator<Container> it, IntVar v, int lb, int ub) {
        while (it.hasNext()) {
            this.checkCont(it.next(), v, lb, ub);
        }
    }

    private void checkCont(Container ct, IntVar v, int lb, int ub) {
        if (!ct.isActive()) {
            return;
        }
        ESat check = ClauseStore.check(lb, ub, ct.s, ct.e, v);
        if (check != ESat.UNDEFINED) {
            if (check == ESat.FALSE) {
                ct.sweepOnFalse();
            } else {
                ct.sweepOnTrue();
            }
            this.model.getEnvironment().save(ct::setActive);
            ct.setPassive();
        }
    }

    private static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    private static ESat check(int lv, int uv, int l, int u, IntVar v) {
        if (l <= lv && uv <= u) {
            return ESat.TRUE;
        }
        if (l > uv || lv > u || v.hasEnumeratedDomain() && v.nextValue(l - 1) > u) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    public class SignedClause
    extends Propagator<IntVar> {
        static final short LOCK = 4;
        private static final byte F0 = 0;
        private static final byte F1 = 1;
        protected static final byte F2 = 2;
        private byte FL;
        private final IntVar[] mvars;
        private final int[] bounds;
        private final int[] pos;
        private double activity;
        private int rawActivity;
        private final int id;
        IntIterableRangeSet uua;

        SignedClause(IntVar[] vars, IntIterableRangeSet[] ranges) {
            int i;
            super((Variable[])new IntVar[]{vars[0], vars[0]}, (Priority)ClauseStore.computePriority(vars.length), false, false);
            this.activity = 0.0;
            this.rawActivity = 0;
            this.vars = new IntVar[0];
            this.uua = new IntIterableRangeSet();
            this.setActive0();
            this.id = SID++;
            int size = 0;
            for (i = 0; i < ranges.length; ++i) {
                size += ranges[i].getNbRanges();
            }
            this.pos = ArrayUtils.array(0, size - 1);
            this.mvars = new IntVar[size];
            this.bounds = new int[size << 1];
            int k = -1;
            for (i = 0; i < ranges.length; ++i) {
                for (int r = 0; r < ranges[i].getNbRanges(); ++r) {
                    this.mvars[++k] = vars[i];
                    this.bounds[k << 1] = ranges[i].minOfRange(r);
                    this.bounds[(k << 1) + 1] = ranges[i].maxOfRange(r);
                }
            }
            if (ranges[0].getNbRanges() > 1) {
                int nbr = ranges[0].getNbRanges();
                int p = this.pos[1];
                this.pos[1] = this.pos[nbr];
                this.pos[nbr] = p;
            }
        }

        public final int cardinality() {
            return this.mvars.length;
        }

        private ESat check(int p) {
            return ClauseStore.check(this.mvars[p].getLB(), this.mvars[p].getUB(), this.bounds[p << 1], this.bounds[(p << 1) + 1], this.mvars[p]);
        }

        private boolean restrict(int p) throws ContradictionException {
            return this.mvars[p].updateBounds(this.bounds[p << 1], this.bounds[(p << 1) + 1], this);
        }

        public final boolean isConnected() {
            return this.pos[0] > -1 && this.pos[1] > -1;
        }

        @Override
        public final void propagate(int evtmask) throws ContradictionException {
            if (evtmask == 2) {
                if (!this.isConnected()) {
                    return;
                }
                switch (this.check(this.pos[0])) {
                    case TRUE: {
                        this.FL = 0;
                        this.setPassive();
                        return;
                    }
                    case FALSE: {
                        this.FL = (byte)(this.FL | 1);
                        break;
                    }
                }
                switch (this.check(this.pos[1])) {
                    case TRUE: {
                        this.FL = 0;
                        this.setPassive();
                        return;
                    }
                    case FALSE: {
                        this.FL = (byte)(this.FL | 2);
                        break;
                    }
                }
            }
            if (this.FL != 0) {
                this.propagateClause();
            }
            if (evtmask == 2 && this.isActive()) {
                this.detectHiddenUUA();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void detectHiddenUUA() throws ContradictionException {
            IntVar one = null;
            this.uua.clear();
            block4: for (int i = 0; i < this.pos.length; ++i) {
                switch (this.check(i)) {
                    case UNDEFINED: {
                        if (one == null || one == this.mvars[i]) {
                            one = this.mvars[i];
                            this.uua.addBetween(this.bounds[i << 1], this.bounds[(i << 1) + 1]);
                            break;
                        }
                        one = null;
                        break block4;
                    }
                    case TRUE: {
                        one = null;
                        break block4;
                    }
                }
            }
            if (one == null) return;
            if (one.removeAllValuesBut(this.uua, this)) {
                this.setPassiveAndLock();
                return;
            }
            this.setPassive();
        }

        private void propagateClause() throws ContradictionException {
            int k = 2;
            int to = this.pos.length;
            do {
                boolean p;
                if ((this.FL & 2) != 0) {
                    p = true;
                    this.FL = (byte)(this.FL ^ 2);
                } else {
                    p = false;
                    this.FL = (byte)(this.FL ^ 1);
                }
                int l0 = this.pos[0];
                int l1 = this.pos[1];
                if (!p) {
                    int t = l0;
                    this.pos[0] = l0 = l1;
                    this.pos[1] = l1 = t;
                }
                boolean cont = false;
                while (k < to) {
                    int l = this.pos[k];
                    ESat b = this.check(l);
                    if (b != ESat.FALSE) {
                        this.pos[1] = l;
                        this.pos[k] = this.pos[--to];
                        this.pos[to] = l1;
                        ClauseStore.this.attach(new Watcher(l, this));
                        if (b == ESat.TRUE) {
                            this.setPassive();
                            this.FL = 0;
                            assert (this.isEntailed() == ESat.TRUE);
                            return;
                        }
                        cont = true;
                        break;
                    }
                    ++k;
                }
                if (cont) continue;
                this.FL = 0;
                if (this.restrict(l0)) {
                    assert (this.isEntailed() == ESat.TRUE);
                    this.setPassiveAndLock();
                    return;
                }
                assert (this.isEntailed() != ESat.FALSE);
            } while (this.FL != 0);
        }

        private void setPassiveAndLock() {
            this.state = (short)4;
            this.model.getEnvironment().save(this.operations[2]);
        }

        int getNbFalsified() {
            int count = 0;
            for (int i = 0; i < this.pos.length; ++i) {
                ESat b = this.check(i);
                if (b != ESat.FALSE) continue;
                ++count;
            }
            return count;
        }

        int getNbSatisfied() {
            int count = 0;
            for (int i = 0; i < this.pos.length; ++i) {
                ESat b = this.check(i);
                if (b != ESat.TRUE) continue;
                ++count;
            }
            return count;
        }

        boolean isNotLocked() {
            return this.state != 4;
        }

        IntVar v(int i) {
            return this.mvars[i];
        }

        int l(int i) {
            return this.bounds[i << 1];
        }

        int u(int i) {
            return this.bounds[(i << 1) + 1];
        }

        final int dominate(SignedClause cj) {
            if (this.mvars.length < cj.mvars.length) {
                return this.outhsine0(this, cj);
            }
            if (this.mvars.length > cj.mvars.length) {
                return -this.outhsine0(cj, this);
            }
            return this.outhsine1(this, cj);
        }

        private int outhsine0(SignedClause ci, SignedClause cj) {
            int[] idx = new int[]{0, 0};
            boolean outs = true;
            while (idx[0] <= ci.mvars.length - 1 && idx[1] <= cj.mvars.length - 1 && outs) {
                int idj;
                int idi = ci.mvars[idx[0]].getId();
                if (idi == (idj = cj.mvars[idx[1]].getId())) {
                    outs = this.includedIn(ci, cj, idi, idj, idx);
                    continue;
                }
                if (idj < idi) {
                    idx[1] = idx[1] + 1;
                    outs = idx[1] >= idx[0];
                    continue;
                }
                outs = false;
            }
            return outs ? 1 : 0;
        }

        private int outhsine1(SignedClause ci, SignedClause cj) {
            int idj;
            int idi;
            int outi = 0;
            int outj = 0;
            int skip = 0;
            for (int k = ci.mvars.length - 1; k >= 0 && skip < 3 && (idi = ci.mvars[k].getId()) == (idj = cj.mvars[k].getId()); --k) {
                if (outi >= outj && cj.l(k) <= ci.l(k) && ci.u(k) <= cj.u(k)) {
                    ++outi;
                } else {
                    skip = (byte)(skip | 1);
                }
                if (outj >= outi - 1 && ci.l(k) <= cj.l(k) && cj.u(k) <= ci.u(k)) {
                    ++outj;
                    continue;
                }
                skip = (byte)(skip | 2);
            }
            if (outi == ci.mvars.length) {
                return 1;
            }
            if (outj == cj.mvars.length) {
                return -1;
            }
            return 0;
        }

        boolean includedIn(SignedClause ci, SignedClause cj, int idi, int idj, int[] idx) {
            int lbi = ci.l(idx[0]);
            int ubi = ci.u(idx[0]);
            int lbj = cj.l(idx[1]);
            int ubj = cj.u(idx[1]);
            while (idx[0] <= ci.mvars.length - 1 && idi == ci.mvars[idx[0]].getId() && idx[1] <= cj.mvars.length - 1 && idj == cj.mvars[idx[1]].getId()) {
                if (ubj < lbi && (idx[1] = idx[1] + 1) <= cj.mvars.length - 1 && idj == cj.mvars[idx[1]].getId()) {
                    lbj = cj.l(idx[1]);
                    ubj = cj.u(idx[1]);
                    continue;
                }
                if (lbj <= lbi && ubi <= ubj) {
                    idx[0] = idx[0] + 1;
                    if (idx[0] > ci.mvars.length - 1 || idi != ci.mvars[idx[0]].getId()) continue;
                    lbi = ci.l(idx[0]);
                    ubi = ci.u(idx[0]);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public final ESat isEntailed() {
            boolean u = false;
            for (int i = 0; i < this.pos.length; ++i) {
                ESat b = this.check(i);
                if (b == ESat.TRUE) {
                    return ESat.TRUE;
                }
                if (b != ESat.UNDEFINED) continue;
                u = true;
            }
            return u ? ESat.UNDEFINED : ESat.FALSE;
        }

        @Override
        public void explain(int p, ExplanationForSignedClause explanation) {
            IntVar pivot = explanation.readVar(p);
            this.activity += ClauseStore.this.clauseInc;
            ++this.rawActivity;
            int i = 0;
            while (i < this.mvars.length) {
                IntVar v = this.mvars[i];
                if (explanation.getFront().getValueOrDefault(v, -1) == -1) {
                    explanation.getImplicationGraph().findPredecessor(explanation.getFront(), v, p);
                }
                IntIterableRangeSet set = explanation.empty();
                do {
                    set.addBetween(this.bounds[i << 1], this.bounds[(i << 1) + 1]);
                } while (++i < this.mvars.length && this.mvars[i - 1] == this.mvars[i]);
                if (v == pivot) {
                    v.intersectLit(set, explanation);
                    continue;
                }
                v.unionLit(set, explanation);
            }
        }

        @Override
        public String toString() {
            StringBuilder st = new StringBuilder();
            st.append("#").append(this.id).append(" : ");
            st.append("?").append((Object)this.isEntailed()).append(" : ");
            st.append('(').append(this.mvars[this.pos[0]]).append(" \u2208 [").append(this.bounds[this.pos[0] << 1]).append(',').append(this.bounds[(this.pos[0] << 1) + 1]).append(']');
            st.append(':').append((Object)this.check(this.pos[0]));
            for (int i = 1; i < this.pos.length; ++i) {
                st.append(") \u2228 (");
                st.append(this.mvars[this.pos[i]]).append(" \u2208 [").append(this.bounds[this.pos[i] << 1]).append(',').append(this.bounds[(this.pos[i] << 1) + 1]).append(']');
                st.append(':').append((Object)this.check(this.pos[i]));
            }
            st.append(')');
            return st.toString();
        }
    }

    private static final class Watcher {
        int p;
        SignedClause c;

        Watcher(int p, SignedClause c) {
            this.p = p;
            this.c = c;
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private final class Container
    implements Interval {
        int s;
        int e;
        ShrinkableList<Watcher> watchers;
        boolean active = true;

        Container(int s, int e) {
            this.s = s;
            this.e = e;
            this.watchers = new ShrinkableList();
        }

        @Override
        public int start() {
            return this.s;
        }

        @Override
        public int end() {
            return this.e;
        }

        public void add(Watcher w) {
            this.watchers.add(w);
        }

        boolean isActive() {
            return this.active;
        }

        void setPassive() {
            this.active = false;
        }

        void setActive() {
            this.active = true;
        }

        void sweepOnFalse() {
            int i;
            int j = i = 0;
            int s = this.watchers.size();
            while (i < s) {
                Watcher w = (Watcher)this.watchers.get(i++);
                SignedClause c = w.c;
                int p = 0;
                if (w.p != c.pos[0] && w.p != c.pos[++p]) continue;
                if (w.c.isScheduled()) {
                    this.watchers.set(j++, w);
                    continue;
                }
                if (!w.c.isActive()) {
                    ClauseStore.this.model.getEnvironment().save(() -> {
                        if (w.c.isConnected()) {
                            ClauseStore.this.attach(w);
                        }
                    });
                    continue;
                }
                this.watchers.set(j++, w);
                ClauseStore.this.mSolver.getEngine().schedule(w.c, p, 1);
            }
            this.watchers.removeRange(j, i);
        }

        void sweepOnTrue() {
            int i = 0;
            int j = 0;
            int s = this.watchers.size();
            while (i < s) {
                Watcher w = (Watcher)this.watchers.get(i++);
                SignedClause c = w.c;
                if (w.p != c.pos[0] && w.p != c.pos[1]) continue;
                this.watchers.set(j++, w);
            }
            this.watchers.removeRange(j, i);
        }

        public String toString() {
            return String.format("[%d,%d]", this.start(), this.end());
        }
    }
}

