/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.impl.DirectedGraphVarImpl;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class DirectedNodeInducedGraphVarImpl
extends DirectedGraphVarImpl
implements ICause {
    private final DirectedGraph originalUB;

    public DirectedNodeInducedGraphVarImpl(String name, Model solver, DirectedGraph LB, DirectedGraph UB) {
        super(name, solver, LB, UB);
        this.originalUB = new DirectedGraph(UB);
    }

    @Override
    public boolean enforceNode(int x, ICause cause) throws ContradictionException {
        int y;
        boolean nodeEnforced = super.enforceNode(x, cause);
        if (!nodeEnforced) {
            return false;
        }
        boolean edgeAdded = false;
        ISetIterator iSetIterator = this.originalUB.getSuccessorsOf(x).iterator();
        while (iSetIterator.hasNext()) {
            y = (Integer)iSetIterator.next();
            if (((DirectedGraph)this.LB).containsNode(y)) {
                if (!((DirectedGraph)this.UB).containsEdge(x, y)) {
                    this.contradiction(cause, "Cannot enforce node " + x + " because edge (" + x + ", " + y + ") was removed from the envelope");
                }
                if (!((DirectedGraph)this.LB).addEdge(x, y)) continue;
                if (this.reactOnModification) {
                    this.delta.add(x, 4, cause);
                    this.delta.add(y, 5, cause);
                }
                edgeAdded = true;
                continue;
            }
            if (!((DirectedGraph)this.UB).containsNode(y) || ((DirectedGraph)this.UB).containsEdge(x, y)) continue;
            this.removeNode(y, this);
        }
        iSetIterator = this.originalUB.getPredecessorsOf(x).iterator();
        while (iSetIterator.hasNext()) {
            y = (Integer)iSetIterator.next();
            if (((DirectedGraph)this.LB).containsNode(y)) {
                if (!((DirectedGraph)this.UB).containsEdge(x, y)) {
                    this.contradiction(cause, "Cannot enforce node " + x + " because edge (" + y + ", " + x + ") was removed from the envelope");
                }
                if (!((DirectedGraph)this.LB).addEdge(y, x)) continue;
                if (this.reactOnModification) {
                    this.delta.add(y, 4, cause);
                    this.delta.add(x, 5, cause);
                }
                edgeAdded = true;
                continue;
            }
            if (!((DirectedGraph)this.UB).containsNode(y) || ((DirectedGraph)this.UB).containsEdge(y, x)) continue;
            this.removeNode(y, this);
        }
        if (edgeAdded) {
            this.notifyPropagators(GraphEventType.ADD_EDGE, this);
        }
        return true;
    }

    @Override
    public boolean removeEdge(int x, int y, ICause cause) throws ContradictionException {
        boolean edgeRemoved = super.removeEdge(x, y, cause);
        if (!edgeRemoved) {
            return false;
        }
        boolean xInKer = this.getMandatoryNodes().contains(x);
        boolean yInKer = this.getMandatoryNodes().contains(y);
        if (xInKer && yInKer) {
            this.contradiction(cause, "Remove mandatory edge");
        }
        if (xInKer && !yInKer) {
            this.removeNode(y, this);
        }
        if (!xInKer && yInKer) {
            this.removeNode(x, this);
        }
        return true;
    }
}

