/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.List;
import org.restopt.RestoptProblem;
import org.restopt.RestoptSolution;
import org.restopt.exception.RestoptException;
import org.restopt.objectives.EffectiveMeshSizeObjective;
import org.restopt.objectives.IntegralIndexOfConnectivityObjective;
import org.restopt.objectives.MinRestoreObjective;
import org.restopt.objectives.NbPlanningUnitsObjective;
import org.restopt.objectives.NoOptimizationObjective;

public interface IRestoptObjectiveFactory {
    public RestoptProblem self();

    default public RestoptSolution findSolution(int timeLimit, boolean verbose) throws RestoptException {
        return this.findSolutions(1, timeLimit, verbose).get(0);
    }

    default public RestoptSolution maximizeMESH(int precision, int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        return this.maximizeMESH(1, precision, timeLimit, optimalityGap, verbose).get(0);
    }

    default public RestoptSolution maximizeIIC(int precision, int distanceThreshold, int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        return this.maximizeIIC(1, precision, distanceThreshold, timeLimit, optimalityGap, verbose).get(0);
    }

    default public RestoptSolution maximizeMinRestore(int timeLimit, double optimalityGap, boolean verbose) throws Exception {
        return this.maximizeMinRestore(1, timeLimit, optimalityGap, verbose).get(0);
    }

    default public RestoptSolution maximizeNbPUS(int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        return this.maximizeNbPUS(1, timeLimit, optimalityGap, verbose).get(0);
    }

    default public RestoptSolution minimizeNbPUS(int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        return this.minimizeNbPUS(1, timeLimit, optimalityGap, verbose).get(0);
    }

    default public List<RestoptSolution> findSolutions(int nbSolutions, int timeLimit, boolean verbose) throws RestoptException {
        NoOptimizationObjective obj = new NoOptimizationObjective(this.self(), timeLimit, verbose);
        return obj.findOptimalSolution(nbSolutions, 0.0);
    }

    default public List<RestoptSolution> maximizeMESH(int nbSolutions, int precision, int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        EffectiveMeshSizeObjective obj = new EffectiveMeshSizeObjective(this.self(), timeLimit, verbose, true, precision);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> maximizeIIC(int nbSolutions, int precision, int distanceThreshold, int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        IntegralIndexOfConnectivityObjective obj = new IntegralIndexOfConnectivityObjective(this.self(), timeLimit, verbose, true, precision, distanceThreshold);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> maximizeMinRestore(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose) throws Exception {
        MinRestoreObjective obj = new MinRestoreObjective(this.self(), timeLimit, verbose, true);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> minimizeMinRestore(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose) throws Exception {
        MinRestoreObjective obj = new MinRestoreObjective(this.self(), timeLimit, verbose, false);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> maximizeNbPUS(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        NbPlanningUnitsObjective obj = new NbPlanningUnitsObjective(this.self(), timeLimit, verbose, true);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> minimizeNbPUS(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose) throws RestoptException {
        NbPlanningUnitsObjective obj = new NbPlanningUnitsObjective(this.self(), timeLimit, verbose, false);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> findSolutions(int nbSolutions, int timeLimit, boolean verbose, String search) throws RestoptException {
        NoOptimizationObjective obj = new NoOptimizationObjective(this.self(), timeLimit, verbose, search);
        return obj.findOptimalSolution(nbSolutions, 0.0);
    }

    default public List<RestoptSolution> maximizeMESH(int nbSolutions, int precision, int timeLimit, double optimalityGap, boolean verbose, String search) throws RestoptException {
        EffectiveMeshSizeObjective obj = new EffectiveMeshSizeObjective(this.self(), timeLimit, verbose, true, precision, search);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> maximizeIIC(int nbSolutions, int precision, int distanceThreshold, int timeLimit, double optimalityGap, boolean verbose, String search) throws RestoptException {
        IntegralIndexOfConnectivityObjective obj = new IntegralIndexOfConnectivityObjective(this.self(), timeLimit, verbose, true, precision, distanceThreshold, search);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> maximizeMinRestore(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose, String search) throws Exception {
        MinRestoreObjective obj = new MinRestoreObjective(this.self(), timeLimit, verbose, true, search);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> minimizeMinRestore(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose, String search) throws Exception {
        MinRestoreObjective obj = new MinRestoreObjective(this.self(), timeLimit, verbose, false, search);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> maximizeNbPUS(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose, String search) throws RestoptException {
        NbPlanningUnitsObjective obj = new NbPlanningUnitsObjective(this.self(), timeLimit, verbose, true, search);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }

    default public List<RestoptSolution> minimizeNbPUS(int nbSolutions, int timeLimit, double optimalityGap, boolean verbose, String search) throws RestoptException {
        NbPlanningUnitsObjective obj = new NbPlanningUnitsObjective(this.self(), timeLimit, verbose, false, search);
        return obj.findOptimalSolution(nbSolutions, optimalityGap);
    }
}

