% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rentrez-wrappers.R
\name{entrez_fetch}
\alias{entrez_fetch}
\title{Entrez fetch}
\usage{
entrez_fetch(db, id = NULL, rettype, retmode = "", ...)
}
\arguments{
\item{db}{character, name of the database}

\item{id}{vector, unique ID(s) for record(s)}

\item{rettype}{character, data format}

\item{retmode}{character, data mode}

\item{...}{Arguments to be passed on to rentrez}
}
\value{
character string containing the file created
}
\description{
Wrapper for rentrez::entrez_fetch.
}
\details{
Attempts to first search local database with user-specified
parameters, if the record is missing in the database, the function then
calls rentrez::entrez_fetch to search GenBank remotely.

\code{rettype='fasta'} and \code{rettype='gb'} are respectively equivalent to 
\code{\link{gb_fasta_get}} and \code{\link{gb_record_get}}.
}
\note{
It is advisable to call restez and rentrez functions with '::' notation
rather than library() calls to avoid namespace issues. e.g.
restez::entrez_fetch().
}
\section{Supported return types and modes}{

XML retmode is not supported. Rettypes 'seqid', 'ft', 'acc' and 'uilist'
are also not supported.
}

\examples{
library(restez)
restez_path_set(tempdir())
demo_db_create(n = 5)
restez_connect()
# return fasta record
fasta_res <- entrez_fetch(db = 'nucleotide',
                          id = c('demo_1', 'demo_2'),
                          rettype = 'fasta')
cat(fasta_res)
# return whole GB record in text format
gb_res <- entrez_fetch(db = 'nucleotide',
                       id = c('demo_1', 'demo_2'),
                       rettype = 'gb')
cat(gb_res)
# NOT RUN
# whereas these request would go through rentrez
# fasta_res <- entrez_fetch(db = 'nucleotide',
#                           id = c('S71333', 'S71334'),
#                           rettype = 'fasta')
# gb_res <- entrez_fetch(db = 'nucleotide',
#                        id = c('S71333', 'S71334'),
#                        rettype = 'gb')

# delete demo after example
db_delete(everything = TRUE)
}
\seealso{
\code{\link[rentrez]{entrez_fetch}}
}
\concept{entrez}
