% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_pcrit.R
\encoding{UTF-8}
\name{calc_pcrit}
\alias{calc_pcrit}
\title{Calculate Pcrit (hypoxia tolerance)}
\usage{
calc_pcrit(po2, mo2, level = 0.95, iqr = 1.5, NLR_m = 0.065)
}
\arguments{
\item{po2}{a vector of PO2 values. Any unit of measurement should work, but the NLR calculation was optimized using kPa. If the NLR metric is giving you trouble, try converting to kPa using \code{\link{conv_o2}}.}

\item{mo2}{a vector of metabolic rate values. Must be the same length and corresponding to \code{po2}.}

\item{level}{applies to the \code{Sub_PI} metric only. Percentage at which the prediction interval should be constructed. Default is 0.95.}

\item{iqr}{applies to the \code{Sub_PI} metric only. Removes \code{mo2} observations that are this many interquartile ranges away from the mean value for the oxyregulating portion of the trial. If this filtering is not desired, set to infinity. To visualize which observations will be removed by this parameter, use \code{\link{plot_pcrit}}. Default is 1.5.}

\item{NLR_m}{applies to the \code{NLR} metric only. Pcrit is defined as the PO2 at which the slope of the best fitting function equals \code{NLR_m} (after the MO2 data are normalized to the 90\% quantile). Default is 0.065.}
}
\value{
A named numeric vector of Pcrit values calculated using the \code{Breakpoint}, \code{Sub_PI}, and \code{NLR} metrics.
}
\description{
Calculates Pcrit (the threshold below which oxygen consumption rate can no longer be sustained) based on paired PO2 and MO2 values. Three Pcrit metrics are returned: the traditional breakpoint metric (broken stick regression), the nonlinear regression metric (Marshall et al. 2013), and the sub-prediction interval metric (Birk et al. 2019). To see the Pcrit values plotted, see \code{\link{plot_pcrit}}.
}
\details{
\describe{
\item{Breakpoint Pcrit}{Data are fit to a broken-stick regression using \code{\link[segmented]{segmented}}.}
\item{Sub_PI Pcrit}{This metric builds off the \code{Breakpoint} metric and results in a systematically lower Pcrit value. This is useful for applications where it is important to ensure that Pcrit is not being overestimated. It represents a reasonable lower bounded estimate of the Pcrit value for a given trial. Once the \code{Breakpoint} Pcrit is calculated, a 95\% prediction interval (can be changed with the \code{level} argument) is calculated around the oxyregulating region (i.e. using PO2 values > breakpoint Pcrit). By default, \code{iqr} provides some filtering of abberant observations to prevent their influence on the calculated prediction interval. Finally, the Sub_PI Pcrit value is returned at the intersection of the oxyconforming line and the lower limit of the oxyregulating prediction interval.}
\item{NLR Pcrit}{Data are fit to the following functions: Michaelis-Menten, Power, Hyperbola, Pareto, and Weibull with intercept. Following the method developed by Marshall et al. 2013, the function that best fits the data (smallest AIC) is chosen and the Pcrit is determined as the PO2 at which the slope of the function is \code{NLR_m} (by default = 0.065 following the authors' suggestion).}
}
}
\examples{
mo2_data <- read.csv(system.file('extdata', 'mo2_v_po2.csv', package = 'respirometry'))
calc_pcrit(po2 = mo2_data$po2, mo2 = mo2_data$mo2)
}
\references{
Marshall, Dustin J., Michael Bode, and Craig R. White. 2013. “Estimating Physiological Tolerances - a Comparison of Traditional Approaches to Nonlinear Regression Techniques.” Journal of Experimental Biology 216(12): 2176–82.

Birk, Matthew A., K.A.S. Mislan, Karen F. Wishner, and Brad A. Seibel. 2019. “Metabolic adaptations of the pelagic octopod Japetella diaphana to oxygen minimum zones.” Deep-Sea Research Part I.
}
\seealso{
\code{\link{plot_pcrit}}, \code{\link{calc_MO2}}, \code{\link{conv_o2}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
