% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resmush_clean_dir.R
\name{resmush_clean_dir}
\alias{resmush_clean_dir}
\title{Helper function for cleaning files created by \strong{resmush}}
\usage{
resmush_clean_dir(dir, suffix = "_resmush", recursive = FALSE)
}
\arguments{
\item{dir}{A character vector of full path names. See \code{\link[=list.files]{list.files()}}, \code{path}
argument.}

\item{suffix}{Character, defaults to \code{"_resmush"}. See \code{\link[=resmush_file]{resmush_file()}}.}

\item{recursive}{Logical. Should the files to be deleted recurse into
directories?}
}
\value{
Nothing. Produce messages with information of the process.
}
\description{
\strong{Use with caution}. This would remove files from your computer.

Clean a directory (or a list of directories) of files created by
\code{\link[=resmush_file]{resmush_file()}}.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Simple example

png_file <- system.file("extimg/example.png", package = "resmush")


# Copy to a temporary file with a given suffix
suffix <- "_would_be_removed"
tmp_png <- file.path(
  tempdir(),
  paste0("example", suffix, ".png")
)

file.exists(tmp_png)
file.copy(png_file, tmp_png, overwrite = TRUE)

file.exists(tmp_png)

# This won't remove it
resmush_clean_dir(tempdir())

file.exists(tmp_png)

# Need suffix
resmush_clean_dir(tempdir(), suffix = suffix)

file.exists(tmp_png)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=resmush_file]{resmush_file()}}, \code{\link[=resmush_dir]{resmush_dir()}}, \code{\link[=list.files]{list.files()}}, \code{\link[=unlink]{unlink()}}
}
\concept{helpers}
\keyword{internal}
