% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_generics.R,
%   R/distribution_methods.R
\name{fit_dist}
\alias{fit_dist}
\alias{fit_dist_direct}
\alias{fit.Distribution}
\title{Fit a general distribution to observations}
\usage{
fit_dist(dist, obs, start, ...)

fit_dist_direct(dist, obs, start, ..., .start_with_default = FALSE)

\method{fit}{Distribution}(object, obs, start, ...)
}
\arguments{
\item{dist}{A \code{Distribution} object.}

\item{obs}{Set of observations as produced by \code{\link[=trunc_obs]{trunc_obs()}} or convertible
via \code{\link[=as_trunc_obs]{as_trunc_obs()}}.}

\item{start}{Initial values of all placeholder parameters.
If missing, starting values are obtained from \code{\link[=fit_dist_start]{fit_dist_start()}}.}

\item{...}{Distribution-specific arguments for the fitting procedure}

\item{.start_with_default}{Before directly optimising the likelihood, use an optimised algorithm for finding
better starting values?}

\item{object}{same as parameter \code{dist}}
}
\value{
A list with at least the elements
\itemize{
\item \code{params} the fitted parameters in the same structure as \code{init}.
\item \code{logLik} the final log-likelihood
}

Additional information may be provided depending on \code{dist}.
}
\description{
The default implementation performs maximum likelihood estimation on all
placeholder parameters.
}
\details{
For Erlang mixture distributions and for Mixture distributions, an
EM-Algorithm is instead used to improve stability.

\code{fit()} and \code{fit_dist()} will chose an optimisation method optimized for the specific distribution given.
\code{fit_dist_direct()} can be used to force direct maximisation of the likelihood.
}
\examples{
x <- rexp(100)
lambda_hat <- 1 / mean(x)
lambda_hat2 <- fit_dist(dist_exponential(), x)$params$rate
identical(lambda_hat, lambda_hat2)
dist <- dist_mixture(list(dist_normal(), dist_translate(dist_exponential(), offset = 6)))
params <- list(
  dists = list(list(mean = 5, sd = 1), list(dist = list(rate = 1))), probs = list(0.95, 0.05)
)
set.seed(2000)
u <- runif(100, 10, 20)
x <- dist$sample(100, with_params = params)
obs <- trunc_obs(x = x[x <= u], tmin = -Inf, tmax = u[x <= u])

default_fit <- fit_dist(dist, obs)
direct_fit <- fit_dist_direct(dist, obs)
# NB: direct optimisation steps with pre-run take a few seconds
\donttest{
direct_fit_init <- fit_dist_direct(dist, obs, start = default_fit$params)
direct_fit_auto_init <- fit_dist_direct(dist, obs, .start_with_default = TRUE)

stopifnot(direct_fit_init$logLik == direct_fit_auto_init$logLik)

c(default_fit$logLik, direct_fit$logLik, direct_fit_init$logLik)
}

}
\seealso{
Other distribution fitting functions: 
\code{\link{fit_blended}()},
\code{\link{fit_erlang_mixture}()},
\code{\link{fit_mixture}()}

Other distribution fitting functions: 
\code{\link{fit_blended}()},
\code{\link{fit_erlang_mixture}()},
\code{\link{fit_mixture}()}
}
\concept{distribution fitting functions}
