% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gprdp}
\alias{gprdp}
\title{Gaussian process regression with linear kernel (gprdp)}
\usage{
gprdp(X, Y, noisev, scale)
}
\arguments{
\item{X}{a matrix of predictor variables}

\item{Y}{a matrix with a single response variable}

\item{noisev}{a value indicating the variance of the noise for Gaussian process regression. Default is 0.001. a matrix with a single response variable}

\item{scale}{a logical indicating whether both the predictors 
and the response variable must be scaled to zero mean and unit variance.}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{Xz}}{ the (final transformed) \code{matrix} of predictor variables.}
\item{\code{alpha}}{ the alpha \code{matrix}.}
\item{\code{is.scaled}}{ logical indicating whether both the predictors and response variable were scaled to zero mean and unit variance.}
\item{\code{Xcenter}}{ if matrix of predictors was scaled, the centering vector used for \code{X}.}
\item{\code{Xscale}}{ if matrix of predictors was scaled, the scaling vector used for \code{X}.}
\item{\code{Ycenter}}{ if matrix of predictors was scaled, the centering vector used for \code{Y}.}
\item{\code{Yscale}}{ if matrix of predictors was scaled, the scaling vector used for \code{Y}.}
}
}
\description{
Carries out a gaussian process regression with a linear kernel (dot product). For internal use only!
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}

