% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_repsd.R
\name{null_repsd}
\alias{null_repsd}
\title{null_repsd}
\usage{
null_repsd(
  item_count = 20,
  focal_sample = 88,
  focal_prop = 0.09,
  numStrata = 4,
  impact = estimate_impact(),
  item_params_a = timmsDiscrim,
  item_params_b = timmsDiffic,
  anchorItems = NULL,
  iterations = 10000,
  verbose = TRUE
)
}
\arguments{
\item{item_count}{numeric. How many items?}

\item{focal_sample}{numeric. How large is the focal sample?}

\item{focal_prop}{numeric, between 0 and 1 (exclusive). What is the proportion
of the focal sample compared to the rest of the data?}

\item{numStrata}{numeric. How many strata for matching should be used?}

\item{impact}{numeric. What is the expected, standardized mean difference
between the focal group's mean theta and the composite group's mean theta
(i.e., standardized focal mean - composite mean). See details for further explanation.}

\item{item_params_a}{numeric vector. What are the discrimination parameters
of the items in the data set?}

\item{item_params_b}{numeric vector. What are the difficulty parameters of
the items in the data set?}

\item{anchorItems}{either \code{NULL} or a vector of the anchorItems names or
numeric column locations. If \code{NULL}, all items are used for calculating the
total test score for stratifying individuals. If a vector, the specified items
are used to calculate the total test score for stratifying individuals.}

\item{iterations}{numeric. How many iterations for the function to run?
Defaults to 10000.}

\item{verbose}{logical. If \code{TRUE} (default), prints a \code{progress::progress_bar()}
in the console to allow tracking of the state of the distribution generation.}
}
\value{
An \code{item_count} x \code{iterations} data.frame with simulated repsd values
for each item.
}
\description{
null_repsd
}
