% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_effectsize.R
\name{report_effectsize}
\alias{report_effectsize}
\title{Report the effect size(s) of a model or a test}
\usage{
report_effectsize(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link{report_effectsize}}.
}
\description{
Computes, interpret and formats the effect sizes of a variety of models and
statistical tests (see list of supported objects in \code{\link{report}}).
}
\examples{
library(report)

# h-tests
report_effectsize(t.test(iris$Sepal.Width, iris$Sepal.Length))
report_effectsize(cor.test(iris$Sepal.Width, iris$Sepal.Length))

# ANOVAs
report_effectsize(aov(Sepal.Length ~ Species, data = iris))

# GLMs
report_effectsize(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
report_effectsize(glm(vs ~ disp, data = mtcars, family = "binomial"))

\donttest{
# Mixed models
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  report_effectsize(model)
}

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, iter = 600)
  report_effectsize(model, effectsize_method = "basic")
}
}
}
