% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_find}
\alias{repo_find}
\title{Match items by matching any field}
\usage{
repo_find(rp, find = NULL, all = F, show = "ds")
}
\arguments{
\item{rp}{An object of class repo.}

\item{find}{Character to match any filed (see Details).}

\item{all}{Show also items tagged with "hide".}

\item{show}{Select columns to show.}
}
\value{
Used for side effects.
}
\description{
Match items by matching any field
}
\details{
This function actually calls print specifying the find
parameters. The find parameter can be any character string to be
matched against any item field, including string-converted size
(like "10x3").
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")

rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", c("tag1", "tag2"))
rp$put(2, "item2", "Sample item 2", c("tag1", "hide"))
rp$put(3, "item3", "Sample item 3", c("tag2", "tag3"))
rp$print()
rp$find("tEm2")
rp$find("ag2", show="t")

## wiping the temp repo
unlink(rp_path, TRUE)

}

