% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_rows.R
\name{replyr_bind_rows}
\alias{replyr_bind_rows}
\title{Bind a list of items by rows (can't use dplyr::bind_rows or dplyr::combine on remote sources).  Columns are intersected.}
\usage{
replyr_bind_rows(lst, ..., useDplyrLocal = TRUE, useSparkRbind = TRUE,
  useUnionALL = TRUE,
  tempNameGenerator = mk_tmp_name_source("replyr_bind_rows"))
}
\arguments{
\item{lst}{list of items to combine, must be all in same dplyr data service}

\item{...}{force other arguments to be used by name}

\item{useDplyrLocal}{logical if TRUE use dplyr for local data.}

\item{useSparkRbind}{logical if TRUE try to use rbind on Sparklyr data}

\item{useUnionALL}{logical if TRUE try to use union all binding}

\item{tempNameGenerator}{temp name generator produced by wrapr::mk_tmp_name_source, used to record dplyr::compute() effects.}
}
\value{
single data item
}
\description{
Bind a list of items by rows (can't use dplyr::bind_rows or dplyr::combine on remote sources).  Columns are intersected.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  # my_db <- sparklyr::spark_connect(master = "local")
  d <- replyr_copy_to(my_db, data.frame(x = 1:2), 'd',
                      temporary = TRUE)
  # dplyr::bind_rows(list(d, d))
  # # Argument 1 must be a data frame or a named atomic vector,
  # # not a tbl_dbi/tbl_sql/tbl_lazy/tbl
  print(replyr_bind_rows(list(d, d)))
  DBI::dbDisconnect(my_db)
}

}
