% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ltransf.R
\name{ecb}
\alias{ecb}
\title{Eisenthal & Cornish-Bowden}
\usage{
ecb(data, unit_S = 'mM', unit_v = 'au', plot = TRUE)
}
\arguments{
\item{data}{a dataframe where the first column is the independent variable, [S], and the remaining columns (as many as experiment replicates) correspond to the dependent variable, v.}

\item{unit_S}{concentration unit.}

\item{unit_v}{time unit.}

\item{plot}{logical. If TRUE data are plotted.}
}
\value{
Returns a list with the estimated values of Km and Vm.
}
\description{
Obtains Km and Vm using the Eisenthal & Cornish-Bowden method.
}
\details{
For each experimental replicate the observations (S, v) are plotted as lines in the Km-Vm parameter space, instead of points in observation space. Afterwards, the lines tend to intersect at a common point, whose coordinates provide the kinetic parameters. Nevertheless, since the observations are subject to error, there is no unique intersection point for all the lines. In this case, the method computes all the pair-wise intersections. Then, the median value from each series is taken to be the best estimate of Km and Vm. This procedure is repeated as many times as replicates and finally the mean and sd is returned.
}
\examples{
ecb(ONPG[, c(1,2)])
}
\references{
Biochem.J.(1974) 139:715-720 (10.1042/bj1390715)
}
\seealso{
lb(), hw(), eh()
}
