% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{snapshot}
\alias{snapshot}
\title{Snapshot a Project}
\usage{
snapshot(
  project = NULL,
  ...,
  library = NULL,
  lockfile = file.path(project, "renv.lock"),
  type = settings$snapshot.type(project = project),
  confirm = interactive(),
  force = FALSE
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R libraries to snapshot. When \code{NULL}, the active \R
libraries (as reported by \code{.libPaths()}) are used.}

\item{lockfile}{The location where the generated lockfile should be written.
By default, the lockfile is written to a file called \code{renv.lock} in the
project directory. When \code{NULL}, the lockfile (as an \R object) is returned
directly instead.}

\item{type}{The type of snapshot to perform. See \strong{Snapshot Type} for
more details. When \code{NULL} (the default), a "packrat"-style snapshot
is performed.}

\item{confirm}{Boolean; prompt the user before taking any action?}

\item{force}{Boolean; force generation of a lockfile even when preflight
validation checks have failed?}
}
\value{
The generated lockfile, as an \R object (invisibly). Note that
this function is normally called for its side effects.
}
\description{
Call \code{snapshot()} to create a \strong{lockfile} capturing the state of a project's
\R package dependencies. The lockfile can be used to later restore these
project's dependencies as required. See the \link{lockfile} documentation for more
details on the structure of a lockfile.
}
\section{Snapshot Type}{


Depending on how you prefer to manage dependencies, you might prefer
selecting a different snapshot mode. The modes available are as follows:

\describe{

\item{\code{"simple"}}{
Capture all packages within the active \R libraries in the lockfile.
This is the quickest and simplest method, but may lead to undesired
packages (e.g. development dependencies) entering the lockfile.
}

\item{\code{"packrat"}}{
Perform a Packrat-style snapshot. The intersection of packages discovered in
your \R libraries, alongside those discovered in your \R code by
\code{renv::dependencies()}, will enter the lockfile. This helps ensure that only
the packages you are using will enter the lockfile, but may be slower if your
project contains a large number of files. If this becomes an issue, you might
consider using \code{.renvignore} files to limit which files \code{renv} uses for
dependency discovery, or explicitly declaring your required dependencies in a
\code{DESCRIPTION} file.
}

\item{\code{"custom"}}{
Like \code{"packrat"}, but use a custom user-defined filter instead. The filter
should be specified by the \R option \code{renv.snapshot.filter}, and should
either be a character vector naming a function (e.g. \code{"package::method"}),
or be a function itself. The function should only accept one argument (the
project directory), and should return a vector of package names to include
in the lockfile.
}

}

By default, \code{"packrat"}-style snapshots are used. The snapshot type can be
configured on a project-specific basis using the \code{renv} project \link{settings}
mechanism.
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
\seealso{
Other reproducibility: 
\code{\link{lockfiles}},
\code{\link{restore}()}
}
\concept{reproducibility}
