% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{remove}
\alias{remove}
\title{Remove Packages}
\usage{
remove(packages, ..., library = NULL, project = NULL)
}
\arguments{
\item{packages}{A character vector of \R packages to remove.}

\item{...}{Optional arguments; reserved for future expansion.}

\item{library}{The library from which packages should be removed. When
\code{NULL}, the active library (that is, the first entry reported in
\code{.libPaths()}) is used instead.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A vector of package records, describing the packages (if any) which
were successfully removed.
}
\description{
Remove (uninstall) \R packages.
}
\examples{
\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
