% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entrez_info.r
\name{entrez_db_searchable}
\alias{entrez_db_searchable}
\title{List available search fields for a given database}
\usage{
entrez_db_searchable(db, config = NULL)
}
\arguments{
\item{db}{character, name of database to get search field from}

\item{config}{config vector passed to \code{httr::GET}}
}
\value{
An eInfoSearch object (subclassed from list) summarizing linked-databases. 
Can be coerced to a data-frame with \code{as.data.frame}. Printing the object
shows only the names of each available search field.
}
\description{
Fetch a list of search fields that can be used with a given database. Fields
can be used as part of the \code{term} argument to \code{\link{entrez_search}}
}
\examples{
\donttest{
pmc_fields <- entrez_db_searchable("pmc")
pmc_fields[["AFFL"]]
entrez_search(db="pmc", term="Otago[AFFL]", retmax=0)
entrez_search(db="pmc", term="Auckland[AFFL]", retmax=0)

sra_fields <- entrez_db_searchable("sra")
as.data.frame(sra_fields)
}
}
\seealso{
\code{\link{entrez_search}}

Other einfo: \code{\link{entrez_db_links}},
  \code{\link{entrez_db_summary}},
  \code{\link{entrez_dbs}}, \code{\link{entrez_info}}
}

