% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{receive}
\alias{receive}
\title{receive}
\usage{
receive(variable, attr_actors = NULL, scaling = c("none", "std"), attr_data)
}
\arguments{
\item{variable}{string with the name of the column in the
\code{attr_actors} object for which the statistic has to be computed.}

\item{attr_actors}{optionally, an object of class
\code{\link[base]{data.frame}} that contains the attribute, see
'Details.'}

\item{scaling}{the method for scaling the statistic. Default is to not scale
the statistic. Alternatively, standardization of the
statistic per time point can be requested with "std".}

\item{attr_data}{Deprecated argument. Please use 'attr_actors' instead.}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a "receive" effect in the tie-oriented model or
the receiver choice step of the actor-oriented model. A "receive" effect
refers to an exogenous actor attribute that affects actor \emph{i}'s rate of
receiving events.
}
\details{
The statistic at timepoint \emph{t} is equal to the value of the exogenous
attribute for actor \emph{i} at time \emph{t} for all dyads in the riskset
that have actor \emph{i} as receiver. Note that a "receive" effect is only
defined for directed relational events.

Construct the `attr_actors` object as a data frame where each row represents 
the attribute value of actor \emph{i} at timepoint \emph{t}:
\itemize{
  \item{name:} The actors' name.
  \item{time:} The time when the attribute values change.
  \item{variable:} The third column contains the attribute used in the
  specification of the "difference" effect. The column name should correspond
  to the string supplied to the \code{variable} argument in the `difference()`
  function.
}

Note that it is possible to omit the `attr_actors` object in the call of
\code{difference()} and, instead, supply it in the call of \code{remstats()}
for multiple exogenous effects.
}
\examples{
data(history)
data(info)

# Tie-oriented model
reh_tie <- remify::remify(history, model = "tie")
effects <- ~ receive("extraversion")
remstats(reh = reh_tie, tie_effects = effects, attr_actors = info)

# Actor-oriented model
reh_actor <- remify::remify(history, model = "actor")
remstats(reh = reh_actor, receiver_effects = effects, attr_actors = info)

}
