% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_reverse.R
\name{nice_reverse}
\alias{nice_reverse}
\title{Easily recode scores}
\usage{
nice_reverse(x, max, min = 1)
}
\arguments{
\item{x}{The score to reverse.}

\item{max}{The maximum score on the scale.}

\item{min}{The minimum score on the scale (optional unless it isn't 1).}
}
\value{
A numeric vector, of reversed scores.
}
\description{
Easily recode scores (reverse-score),
typically for questionnaire answers.
}
\examples{
# Reverse score of 5 with a maximum score of 5
nice_reverse(5, 5)

# Reverse several scores at once
nice_reverse(1:5, 5)

# Reverse scores with maximum = 4 and minimum = 0
nice_reverse(1:4, 4, min = 0)

# Reverse scores with maximum = 3 and minimum = -3
nice_reverse(-3:3, 3, min = -3)

}
\keyword{reverse}
\keyword{scoring}
