% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_haplen.R
\name{calc_haplen}
\alias{calc_haplen}
\title{Calculate length of haplotypes around a focal marker}
\usage{
calc_haplen(furcation)
}
\arguments{
\item{furcation}{an object of class \code{furcation} calculated by \code{\link{calc_furcation}}.}
}
\value{
The functions returns a list containing four elements:
\describe{
\item{mrk.name}{name/identifier of the focal marker.}
\item{position}{position of the focal marker.}
\item{xlim}{positions of left- and rightmost markers covered by extended haplotypes.}
\item{haplen}{a data frame with the coordinates of extended haplotypes around the focal marker.}
}
}
\description{
Calculate for each chromosome the length of its extended haplotype homozygosity.
}
\details{
The length of an extended haplotype is defined as the region
around a focal marker in which a particular chromosome shares
a haplotype with (i.e. is homozygous to) at least one other chromosome.
It is identical to the (horizontal) branch length from the root to the 
last furcation.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#plotting haplotype lengths for both ancestral and derived allele
#of the marker "F1205400"
#which displays a strong signal of selection
f <- calc_furcation(haplohh_cgu_bta12, mrk = "F1205400")
h <- calc_haplen(f)
plot(h)
}
