% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_continuous.R
\name{plot_weighting_continuous}
\alias{plot_weighting_continuous}
\title{Plot weights across a continuous covariate}
\usage{
plot_weighting_continuous(mod, covariate, alpha = 0.05, ...)
}
\arguments{
\item{mod}{Weighting model object}

\item{covariate}{Covariate vector}

\item{alpha}{Number between zero and one indicating the desired alpha level
for confidence intervals.}

\item{...}{unused arguments}
}
\value{
A \code{ggplot2::ggplot} object.
}
\description{
This provides a simple plot for the distribution of a single
continuous covariate in the nominal sample and the implicit sample
defined by the Aronow and Samii (2015) \doi{10.1111/ajps.12185} regression
weights.
}
\details{
Kernel density estimates use the bias-corrected methods of Cattaneo et al (2020).
}
\examples{
y <- rnorm(100)
a <- rbinom(100, 1, 0.5)
x <- rnorm(100)
cov <- runif(100)
mod <- stats::lm(y ~ a + x)
rw_mod <- calculate_weights(mod, "a")
plot_weighting_continuous(rw_mod, cov)
}
\references{
\itemize{
\item Cattaneo, Jansson and Ma (2021): lpdensity: Local Polynomial Density Estimation and Inference.
\emph{Journal of Statistical Software}, forthcoming.
\item Cattaneo, Jansson and Ma (2020): Simple Local Polynomial Density Estimators.
\emph{Journal of the American Statistical Association} 115(531): 1449-1455.
}
}
\seealso{
\code{\link[lpdensity:lpdensity]{lpdensity::lpdensity()}}
}
